/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.httpcomponents;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;

public class LocatorBody
extends AbstractContentBody {
    private final ILocator locator;
    private String charset;

    public LocatorBody(ILocator locator) {
        super(ContentType.APPLICATION_OCTET_STREAM);
        this.locator = locator;
    }

    public LocatorBody(ILocator locator, ContentType contentType) {
        super(contentType);
        this.locator = locator;
    }

    public String getCharset() {
        return this.charset;
    }

    public long getContentLength() {
        try {
            return this.locator.getLength();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public String getFilename() {
        return this.locator.getName();
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void writeTo(OutputStream out) throws IOException {
        InputStream is = null;
        try {
            is = this.locator.getInputStream();
            StreamTools.copy((InputStream)is, (OutputStream)out);
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }
}

