/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.httpcomponents;

import de.intarsys.aaa.authenticate.api.CredentialProvider;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.api.ICredentialProvider;
import de.intarsys.aaa.authenticate.api.ICredentialScope;
import de.intarsys.aaa.authenticate.impl.NTCredential;
import de.intarsys.aaa.authenticate.impl.UserPasswordCredential;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.http.authenticate.HttpCredentialScope;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialCredentialsProvider
implements CredentialsProvider {
    private static final Logger Log = LoggerFactory.getLogger(CredentialCredentialsProvider.class);
    private final ICredentialProvider credentialProvider;

    public CredentialCredentialsProvider() {
        this(null);
    }

    public CredentialCredentialsProvider(ICredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public ICredentialProvider getCredentialProvider() {
        if (this.credentialProvider == null) {
            return CredentialProvider.get();
        }
        return this.credentialProvider;
    }

    public Credentials getCredentials(AuthScope authscope) {
        String host = authscope.getHost();
        try {
            host = InetAddress.getByName(host).getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String scheme = authscope.getScheme();
        HttpCredentialScope scope = new HttpCredentialScope(host, authscope.getPort(), authscope.getRealm(), scheme);
        ICredential credential = this.getCredentialProvider().getCredential((ICredentialScope)scope);
        Credentials result = this.mapCredential(credential, scheme);
        return result;
    }

    protected Credentials mapCredential(ICredential credential, String scheme) {
        if (credential == null) {
            return null;
        }
        if (credential instanceof UserPasswordCredential) {
            String domain;
            boolean nt;
            String password;
            UserPasswordCredential userPwCredential = (UserPasswordCredential)credential;
            String user = userPwCredential.getUser();
            try {
                password = CryptoTools.getString((Secret)userPwCredential.getPassword());
            }
            catch (GeneralSecurityException e) {
                password = null;
            }
            String host = "";
            if (credential instanceof NTCredential) {
                nt = true;
                NTCredential ntCredential = (NTCredential)credential;
                domain = ntCredential.getDomain();
            } else {
                nt = "NTLM".equalsIgnoreCase(scheme);
                domain = "";
            }
            if (nt) {
                return new NTCredentials(user, password, host, domain);
            }
            return new UsernamePasswordCredentials(user, password);
        }
        Log.error("unsupported credential '" + credential.getClass() + "'");
        return null;
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        throw new UnsupportedOperationException();
    }
}

