/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.http.common.HttpTools;
import de.intarsys.tools.http.content.HttpEntityDecoder;
import de.intarsys.tools.http.content.HttpEntityEncoder;
import de.intarsys.tools.http.content.IHttpEntityDecoder;
import de.intarsys.tools.http.content.IHttpEntityEncoder;
import org.apache.http.Header;

public class HttpContentTools {
    public static IHttpEntityDecoder selectDecoder(Header[] headers, IHttpEntityDecoder defaultDecoder) {
        String contentType = HttpTools.getContentTypeName((Header[])headers, null);
        IHttpEntityDecoder decoder = HttpEntityDecoder.lookupDecoder(contentType);
        if (decoder == null) {
            return defaultDecoder;
        }
        return decoder;
    }

    public static IHttpEntityDecoder selectDecoder(String contentType, IHttpEntityDecoder defaultDecoder) {
        IHttpEntityDecoder decoder = HttpEntityDecoder.lookupDecoder(contentType = HttpTools.getHeaderElementName((String)contentType, null));
        if (decoder == null) {
            return defaultDecoder;
        }
        return decoder;
    }

    public static IHttpEntityEncoder selectEncoder(Header[] headers, IHttpEntityEncoder defaultEncoder) {
        String contentType = HttpTools.getHeaderElementName((Header[])headers, (String)"accept", null);
        IHttpEntityEncoder encoder = HttpEntityEncoder.lookupEncoder(contentType);
        if (encoder == null) {
            return defaultEncoder;
        }
        return encoder;
    }

    public static IHttpEntityEncoder selectEncoder(String contentType, IHttpEntityEncoder defaultEncoder) {
        IHttpEntityEncoder encoder = HttpEntityEncoder.lookupEncoder(contentType = HttpTools.getHeaderElementName((String)contentType, null));
        if (encoder == null) {
            return defaultEncoder;
        }
        return encoder;
    }

    private HttpContentTools() {
    }
}

