/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.AbstractXRefParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STStreamXRefSection;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;

public class XRefStreamParser
extends AbstractXRefParser {
    private int[] wSizeDefault = new int[]{1, 2, 1};
    private int[] wSize;

    public XRefStreamParser(STDocument doc, COSDocumentParser parser) {
        super(doc, parser);
    }

    private void initWBytes(STStreamXRefSection xRef) {
        int i;
        COSArray w = xRef.getW();
        if (w == null) {
            this.wSize = this.wSizeDefault;
            return;
        }
        this.wSize = new int[3];
        for (i = 0; i < w.size(); ++i) {
            this.wSize[i] = ((COSInteger)w.get(i)).intValue();
        }
        for (i = w.size(); i < 3; ++i) {
            this.wSize[i] = 0;
        }
    }

    protected void loadPrevious(IRandomAccess randomAccess, STXRefSection xRefSection) throws IOException, COSLoadException {
        long offset = xRefSection.getPreviousOffset();
        if (offset != -1L) {
            XRefStreamParser parser = new XRefStreamParser(this.getDoc(), this.getParser());
            randomAccess.seek(offset);
            STXRefSection xrefStream = ((AbstractXRefParser)parser).parse(randomAccess);
            xRefSection.setPrevious(xrefStream);
        }
    }

    @Override
    public STXRefSection parse(IRandomAccess randomAcces) throws IOException, COSLoadException {
        STXRefSection xRefSection = this.parseXRef(randomAcces);
        this.loadPrevious(randomAcces, xRefSection);
        return xRefSection;
    }

    private void parseStreamContent(STStreamXRefSection section) throws IOException {
        this.initWBytes(section);
        ByteArrayInputStream in = new ByteArrayInputStream(section.cosGetStream().getDecodedBytes());
        COSArray index = section.getIndex();
        Iterator<COSObject> i = index.iterator();
        while (i.hasNext()) {
            COSNumber cosStart = i.next().asNumber();
            if (!i.hasNext()) continue;
            COSNumber cosCount = i.next().asNumber();
            if (cosStart == null || cosCount == null) continue;
            int start = cosStart.intValue();
            int count = cosCount.intValue();
            block6: for (int io = 0; io < count; ++io) {
                int type = this.readType(in);
                switch (type) {
                    case 0: {
                        section.addEntry(this.parseType0(in, start + io));
                        continue block6;
                    }
                    case 1: {
                        section.addEntry(this.parseType1(in, start + io));
                        continue block6;
                    }
                    case 2: {
                        section.addEntry(this.parseType2(in, start + io));
                        continue block6;
                    }
                    default: {
                        this.parseTypeUnknown(in);
                    }
                }
            }
        }
    }

    private STXRefEntry parseType0(ByteArrayInputStream pIn, int objectNumber) {
        int nextFree = (int)this.read(pIn, this.wSize[1], -1L);
        int nextGenNum = (int)this.read(pIn, this.wSize[2], -1L);
        return new STXRefEntryFree(objectNumber, nextGenNum, nextFree);
    }

    private STXRefEntry parseType1(ByteArrayInputStream pIn, int objectNumber) {
        long offset = this.read(pIn, this.wSize[1], -1L);
        int genNum = (int)this.read(pIn, this.wSize[2], 0L);
        return new STXRefEntryOccupied(objectNumber, genNum, offset);
    }

    private STXRefEntry parseType2(ByteArrayInputStream pIn, int objectNumber) {
        int streamObjectNumber = (int)this.read(pIn, this.wSize[1], -1L);
        int indexOfObject = (int)this.read(pIn, this.wSize[2], 0L);
        return new STXRefEntryCompressed(objectNumber, 0, streamObjectNumber, 0, indexOfObject);
    }

    private void parseTypeUnknown(ByteArrayInputStream pIn) {
        this.read(pIn, this.wSize[1], -1L);
        this.read(pIn, this.wSize[1], -1L);
    }

    protected STXRefSection parseXRef(IRandomAccess randomAcces) throws IOException, COSLoadException {
        long offset = randomAcces.getOffset();
        COSStream stream = (COSStream)this.getDoc().getParser().parseIndirectObject(randomAcces, null);
        ((COSIndirectObject)stream.containable()).setDirty(false);
        STStreamXRefSection xRefSection = new STStreamXRefSection(this.getDoc(), offset, stream);
        this.parseStreamContent(xRefSection);
        return xRefSection;
    }

    private long read(ByteArrayInputStream pIn, int numBytes, long defaultValue) {
        if (numBytes == 0) {
            return defaultValue;
        }
        long result = 0L;
        for (int i = 0; i < numBytes; ++i) {
            result <<= 8;
            result += (long)pIn.read();
        }
        return result;
    }

    private int readType(ByteArrayInputStream pIn) {
        return (int)this.read(pIn, this.wSize[0], 1L);
    }
}

