/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefSection;
import java.util.ArrayList;
import java.util.List;

public class STXRefSubsection {
    private STXRefSubsection next;
    private List entries;
    private int start;
    private int size;
    private STXRefSection xRefSection;

    protected STXRefSubsection(int start) {
        this(null, start);
    }

    public STXRefSubsection(STXRefSection xRefSection, int start) {
        this.xRefSection = xRefSection;
        this.start = start;
        this.entries = new ArrayList();
        this.size = 0;
    }

    protected void addEntry(STXRefEntry entry) {
        int number = entry.getObjectNumber();
        if (number < this.getStart()) {
            throw new IllegalArgumentException("can't add object with number " + number);
        }
        int end = this.start + this.size;
        if (this.start <= number && number < end) {
            this.entries.set(number - this.start, entry);
            return;
        }
        if (number == end) {
            this.entries.add(entry);
            ++this.size;
            this.checkNext();
            return;
        }
        throw new IllegalArgumentException("can't add object with number " + number);
    }

    protected void checkNext() {
        if (this.getNext() == null) {
            return;
        }
        if (this.getSize() == 0) {
            this.start = this.getNext().getStart();
            this.mergeWithNext();
            return;
        }
        if (this.start + this.getSize() == this.getNext().getStart()) {
            this.mergeWithNext();
        }
    }

    protected List getEntries() {
        return this.entries;
    }

    protected STXRefEntry getEntry(int objectNumber) {
        return (STXRefEntry)this.entries.get(objectNumber - this.start);
    }

    protected STXRefSubsection getNext() {
        return this.next;
    }

    public int getSize() {
        return this.size;
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.start + this.getSize();
    }

    protected STXRefSection getXRefSection() {
        return this.xRefSection;
    }

    protected boolean isInSection(int objectNumber) {
        return objectNumber >= this.start && objectNumber < this.start + this.getSize();
    }

    protected void mergeWithNext() {
        this.entries.addAll(this.getNext().getEntries());
        this.size = this.entries.size();
        this.setNext(this.getNext().getNext());
    }

    protected void setNext(STXRefSubsection next) {
        this.next = next;
    }

    protected void setXRefSection(STXRefSection xRefSection) {
        this.xRefSection = xRefSection;
    }
}

