/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import java.io.IOException;

public class STXRefEntryOccupied
extends STXRefEntry {
    private long offset;

    public STXRefEntryOccupied(int objectNumber, int generationNumber, long offset) {
        super(objectNumber, generationNumber);
        this.offset = offset;
    }

    @Override
    public void accept(IXRefEntryVisitor visitor) throws XRefEntryVisitorException {
        visitor.visitFromOccupied(this);
    }

    @Override
    public STXRefEntry copy() {
        return new STXRefEntryOccupied(this.getObjectNumber(), this.getGenerationNumber(), this.getOffset());
    }

    @Override
    public STXRefEntryOccupied fill(long pos) {
        this.setOffset(pos);
        return this;
    }

    @Override
    public long getColumn1() {
        return this.getOffset();
    }

    @Override
    public int getColumn2() {
        return this.getGenerationNumber();
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public boolean isFree() {
        return false;
    }

    @Override
    public COSObject load(STDocument doc, ISystemSecurityHandler securityHandler) throws IOException, COSLoadException {
        doc.getRandomAccess().seek(this.getOffset());
        return doc.getParser().parseIndirectObject(doc.getRandomAccess(), securityHandler);
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    protected void unlink() {
    }
}

