/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDAxialShading;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDCoonsShading;
import de.intarsys.pdf.pd.PDFreeFormShading;
import de.intarsys.pdf.pd.PDFunctionBasedShading;
import de.intarsys.pdf.pd.PDLatticeFormShading;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDRadialShading;
import de.intarsys.pdf.pd.PDTensorProductShading;

public abstract class PDShading
extends PDObject {
    private static final COSName DK_AntiAlias = COSName.constant("AntiAlias");
    private static final COSName DK_BBox = COSName.constant("BBox");
    private static final COSName DK_ColorSpace = COSName.constant("ColorSpace");
    protected static final COSName DK_ShadingType = COSName.constant("ShadingType");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final int SHADING_TYPE_AXIAL = 2;
    public static final int SHADING_TYPE_COONS = 6;
    public static final int SHADING_TYPE_FREEFORM = 4;
    public static final int SHADING_TYPE_FUNCTIONBASED = 1;
    public static final int SHADING_TYPE_LATTICEFORM = 5;
    public static final int SHADING_TYPE_RADIAL = 3;
    public static final int SHADING_TYPE_TENSORPRODUCT = 7;
    private boolean antiAlias;
    private CDSRectangle boundingBox;
    private PDColorSpace colorSpace;

    protected PDShading(COSObject object) {
        super(object);
        COSDictionary cosDictionary = object instanceof COSStream ? object.asStream().getDict() : object.asDictionary();
        COSObject cosAntiAlias = cosDictionary.get(DK_AntiAlias);
        this.antiAlias = cosAntiAlias.isNull() ? false : cosAntiAlias.asBoolean().booleanValue();
        COSObject cosBBox = cosDictionary.get(DK_BBox);
        this.boundingBox = cosBBox.isNull() ? null : CDSRectangle.createFromCOS(cosBBox.asArray());
    }

    public CDSRectangle getBoundingBox() {
        return this.boundingBox;
    }

    public PDColorSpace getColorSpace() {
        if (this.colorSpace == null) {
            COSDictionary cosDictionary = this.cosGetObject() instanceof COSStream ? this.cosGetObject().asStream().getDict() : this.cosGetObject().asDictionary();
            this.colorSpace = (PDColorSpace)PDColorSpace.META.createFromCos(cosDictionary.get(DK_ColorSpace));
        }
        return this.colorSpace;
    }

    public abstract int getShadingType();

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class<?> paramInstanceClass) {
            super(paramInstanceClass);
        }

        @Override
        public Class<?> getRootClass() {
            return PDShading.class;
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            COSDictionary cosDictionary = object instanceof COSStream ? object.asStream().getDict() : object.asDictionary();
            int type = ((COSInteger)cosDictionary.get(DK_ShadingType)).intValue();
            switch (type) {
                case 1: {
                    return PDFunctionBasedShading.META;
                }
                case 2: {
                    return PDAxialShading.META;
                }
                case 3: {
                    return PDRadialShading.META;
                }
                case 4: {
                    return PDFreeFormShading.META;
                }
                case 5: {
                    return PDLatticeFormShading.META;
                }
                case 6: {
                    return PDCoonsShading.META;
                }
                case 7: {
                    return PDTensorProductShading.META;
                }
            }
            object.handleException(new COSRuntimeException("unsupported shading type " + type));
            return null;
        }
    }
}

