/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDFileSpecification;
import de.intarsys.pdf.pd.PDFileSpecificationURL;
import de.intarsys.pdf.pd.SubmitFormFlags;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PDActionSubmitForm
extends PDAction {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_ActionType_SubmitForm = COSName.constant("SubmitForm");
    public static final COSName DK_F = COSName.constant("F");
    public static final COSName DK_Fields = COSName.constant("Fields");
    public static final COSName DK_Flags = COSName.constant("Flags");
    private SubmitFormFlags flags;

    public static PDActionSubmitForm createNew(URL url) {
        PDActionSubmitForm result = (PDActionSubmitForm)META.createNew();
        result.setUrl(url);
        return result;
    }

    protected PDActionSubmitForm(COSObject object) {
        super(object);
    }

    protected int basicGetFlags() {
        return this.getFieldInt(DK_Flags, 0);
    }

    protected void basicSetFlags(int newFlags) {
        if (newFlags != 0) {
            this.cosSetField(DK_Flags, COSInteger.create(newFlags));
        } else {
            this.cosRemoveField(DK_Flags);
        }
    }

    @Override
    public COSName cosGetExpectedActionType() {
        return CN_ActionType_SubmitForm;
    }

    public List getFields() {
        COSArray array = this.cosGetField(DK_Fields).asArray();
        if (array != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (COSObject entry : array) {
                if (entry instanceof COSDictionary) {
                    PDAcroFormField field = (PDAcroFormField)PDAcroFormField.META.createFromCos(entry);
                    result.add(field.getQualifiedName());
                    continue;
                }
                result.add(entry.stringValue());
            }
            return result;
        }
        return null;
    }

    protected SubmitFormFlags getFlags() {
        if (this.flags == null) {
            this.flags = new SubmitFormFlags(this);
        }
        return this.flags;
    }

    public URL getUrl() {
        PDFileSpecification fs = this.getUrlSpecification();
        if (fs != null) {
            return ((PDFileSpecificationURL)fs).getURL();
        }
        return null;
    }

    protected PDFileSpecification getUrlSpecification() {
        COSObject cosObject = this.cosGetField(DK_F);
        if (cosObject.isNull()) {
            return null;
        }
        return (PDFileSpecificationURL)PDFileSpecificationURL.META.createFromCos(cosObject);
    }

    public boolean isCanonicalFormat() {
        return this.getFlags().isCanonicalFormat();
    }

    public boolean isEmbedForm() {
        return this.getFlags().isEmbedForm();
    }

    public boolean isExclFKey() {
        return this.getFlags().isExclFKey();
    }

    public boolean isExclNonUserAnnots() {
        return this.getFlags().isExclNonUserAnnots();
    }

    public boolean isExportFormat() {
        return this.getFlags().isExportFormat();
    }

    public boolean isGetMethod() {
        return this.getFlags().isGetMethod();
    }

    public boolean isInclude() {
        return this.getFlags().isInclude();
    }

    public boolean isIncludeAnnotations() {
        return this.getFlags().isIncludeAnnotations();
    }

    public boolean isIncludeAppendSaves() {
        return this.getFlags().isIncludeAppendSaves();
    }

    public boolean isIncludeNoValueFields() {
        return this.getFlags().isIncludeNoValueFields();
    }

    public boolean isNotDEFINED() {
        return this.getFlags().isNotDEFINED();
    }

    public boolean isSubmitCoordinates() {
        return this.getFlags().isSubmitCoordinates();
    }

    public boolean isSubmitPDF() {
        return this.getFlags().isSubmitPDF();
    }

    public boolean isXFDF() {
        return this.getFlags().isXFDF();
    }

    public void setCanonicalFormat(boolean flag) {
        this.getFlags().setCanonicalFormat(flag);
    }

    public void setEmbedForm(boolean flag) {
        this.getFlags().setEmbedForm(flag);
    }

    public void setExclFKey(boolean flag) {
        this.getFlags().setExclFKey(flag);
    }

    public void setExclNonUserAnnots(boolean flag) {
        this.getFlags().setExclNonUserAnnots(flag);
    }

    public void setExportFormat(boolean flag) {
        this.getFlags().setExportFormat(flag);
    }

    protected void setFields(List newFields) {
    }

    public void setGetMethod(boolean flag) {
        this.getFlags().setGetMethod(flag);
    }

    public void setInclude(boolean flag) {
        this.getFlags().setInclude(flag);
    }

    public void setIncludeAnnotations(boolean flag) {
        this.getFlags().setIncludeAnnotations(flag);
    }

    public void setIncludeAppendSaves(boolean flag) {
        this.getFlags().setIncludeAppendSaves(flag);
    }

    public void setIncludeNoValueFields(boolean flag) {
        this.getFlags().setIncludeNoValueFields(flag);
    }

    public void setNotDEFINED(boolean flag) {
        this.getFlags().setNotDEFINED(flag);
    }

    public void setSubmitCoordinates(boolean flag) {
        this.getFlags().setSubmitCoordinates(flag);
    }

    public void setSubmitPDF(boolean flag) {
        this.getFlags().setSubmitPDF(flag);
    }

    public void setUrl(URL url) {
        if (url != null) {
            this.setUrlSpecification(PDFileSpecificationURL.createNew(url));
        } else {
            this.setUrlSpecification(null);
        }
    }

    protected void setUrlSpecification(PDFileSpecification newUrl) {
        this.setFieldObject(DK_F, newUrl);
    }

    public void setXFDF(boolean flag) {
        this.getFlags().setXFDF(flag);
    }

    public static class MetaClass
    extends PDAction.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDActionSubmitForm(object);
        }
    }
}

