/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAction;

public class PDActionJavaScript
extends PDAction {
    public static final COSName CN_ActionType_JavaScript = COSName.constant("JavaScript");
    public static final COSName DK_JS = COSName.constant("JS");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    public static PDActionJavaScript createNew(String script) {
        PDActionJavaScript result = (PDActionJavaScript)META.createNew();
        result.setJavaScript(script);
        return result;
    }

    public static String decodeSource(COSObject cosSource) {
        if (cosSource.isNull()) {
            return null;
        }
        if (cosSource instanceof COSString) {
            return cosSource.stringValue();
        }
        if (cosSource instanceof COSStream) {
            byte[] bytes = ((COSStream)cosSource).getDecodedBytes();
            return COSString.create(bytes).stringValue();
        }
        return null;
    }

    protected PDActionJavaScript(COSObject object) {
        super(object);
    }

    @Override
    public COSName cosGetExpectedActionType() {
        return CN_ActionType_JavaScript;
    }

    public String getJavaScript() {
        COSObject cosObject = this.cosGetField(DK_JS);
        return PDActionJavaScript.decodeSource(cosObject);
    }

    public void setJavaScript(String newJavaScript) {
        this.setFieldString(DK_JS, newJavaScript);
    }

    public static class MetaClass
    extends PDAction.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDActionJavaScript(object);
        }
    }
}

