/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.encoding.GlyphNameMap;
import de.intarsys.pdf.font.CMapCharMap;

public class CMapBFCharNameMap
extends CMapCharMap {
    private final COSName destination;
    private final int destinationCode;

    public CMapBFCharNameMap(byte[] source, COSName destination) {
        super(source);
        this.destination = destination;
        this.destinationCode = GlyphNameMap.Standard.getUnicode(destination.stringValue());
    }

    public COSName getDestination() {
        return this.destination;
    }

    @Override
    public char[] toChars(int codepoint) {
        if (this.source == codepoint) {
            return new char[]{(char)this.destinationCode};
        }
        return null;
    }

    @Override
    public int toCID(int codepoint) {
        if (this.source == codepoint) {
            return this.destinationCode;
        }
        return 0;
    }

    @Override
    public int toCodepoint(int cid) {
        if (cid == this.destinationCode) {
            return this.source;
        }
        return 0;
    }
}

