/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.CIDSystemInfo;
import de.intarsys.pdf.font.CIDWidthMap;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDGlyphs;
import java.io.ByteArrayInputStream;

public abstract class CIDFont
extends PDFont {
    public static final COSName DK_CIDSystemInfo = COSName.constant("CIDSystemInfo");
    public static final COSName DK_DW = COSName.constant("DW");
    public static final COSName DK_W = COSName.constant("W");
    public static final COSName DK_DW2 = COSName.constant("DW2");
    public static final COSName DK_W2 = COSName.constant("W2");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private CIDWidthMap cachedWidthMap = null;

    protected CIDFont(COSObject object) {
        super(object);
    }

    @Override
    protected PDFontDescriptor createBuiltinFontDescriptor() {
        return null;
    }

    public CIDSystemInfo getCIDSystemInfo() {
        return (CIDSystemInfo)CIDSystemInfo.META.createFromCos(this.cosGetField(DK_CIDSystemInfo));
    }

    public CIDWidthMap getCIDWidthMap() {
        if (this.cachedWidthMap == null) {
            this.cachedWidthMap = (CIDWidthMap)CIDWidthMap.META.createFromCos(this.cosGetField(DK_W));
        }
        return this.cachedWidthMap;
    }

    public int getDefaultGlyphWidth() {
        return this.getFieldInt(DK_DW, 1000);
    }

    @Override
    public PDFontStyle getFontStyle() {
        return PDFontStyle.REGULAR;
    }

    public abstract int getGlyphIndex(int var1);

    @Override
    public PDGlyphs getGlyphsEncoded(int codepoint) {
        throw new UnsupportedOperationException("CIDFont can not be used directly");
    }

    public int getGlyphWidthCID(int cid) {
        CIDWidthMap map = this.getCIDWidthMap();
        if (map == null) {
            return this.getFieldInt(DK_DW, 1000);
        }
        int width = this.getCIDWidthMap().getWidth(cid);
        if (width == -1) {
            return this.getFieldInt(DK_DW, 1000);
        }
        return width;
    }

    @Override
    public float getGlyphWidthEncoded(int codepoint) {
        throw new UnsupportedOperationException("CIDFont can not be used directly");
    }

    @Override
    public PDGlyphs getNextGlyphsEncoded(ByteArrayInputStream is) {
        throw new UnsupportedOperationException("CIDFont can not be used directly");
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedWidthMap = null;
    }

    public void setCIDSystemInfo(CIDSystemInfo info) {
        this.setFieldObject(DK_CIDSystemInfo, info);
    }

    public void setCIDWidthMap(CIDWidthMap map) {
        this.setFieldObject(DK_W, map);
    }

    public void setDefaultGlyphWidth(int value) {
        this.setFieldInt(DK_DW, value);
    }

    public static class MetaClass
    extends PDFont.MetaClass {
        protected MetaClass(Class<?> instanceClass) {
            super(instanceClass);
        }
    }
}

