/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.tools.kernel.PDFParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class LZWDecoder {
    private byte[][] stringTable;
    private int tableIndex;
    private int bitsToGet = 9;
    private int bytePointer;
    private int nextData = 0;
    private int nextBits = 0;
    private int[] andTable = new int[]{511, 1023, 2047, 4095};

    public void addStringToTable(byte[] string) {
        this.stringTable[this.tableIndex++] = string;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldString, 0, string, 0, length);
        string[length] = newString;
        this.stringTable[this.tableIndex++] = string;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldString, 0, string, 0, length);
        string[length] = newString;
        return string;
    }

    public byte[] decode(byte[] data) throws IOException {
        int code;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        if (data[0] == 0 && data[1] == 1) {
            throw new PDFParseException("LZW flavour not supported.");
        }
        this.initializeStringTable();
        this.bytePointer = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int oldCode = 0;
        while ((code = this.getNextCode(data)) != 257) {
            byte[] string;
            if (code == 256) {
                this.initializeStringTable();
                code = this.getNextCode(data);
                if (code == 257) break;
                result.write(this.stringTable[code]);
                oldCode = code;
                continue;
            }
            if (code < this.tableIndex) {
                string = this.stringTable[code];
                result.write(string);
                this.addStringToTable(this.stringTable[oldCode], string[0]);
                oldCode = code;
                continue;
            }
            string = this.stringTable[oldCode];
            string = this.composeString(string, string[0]);
            result.write(string);
            this.addStringToTable(string);
            oldCode = code;
        }
        return result.toByteArray();
    }

    public int getNextCode(byte[] data) {
        try {
            this.nextData = this.nextData << 8 | data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int code = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 257;
        }
    }

    public void initializeStringTable() {
        this.stringTable = new byte[8192][];
        for (int i = 0; i < 256; ++i) {
            this.stringTable[i] = new byte[1];
            this.stringTable[i][0] = (byte)i;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }
}

