/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlyphNameMap {
    private static final int ARRAY_MAPPING_SIZE = 256;
    public static final GlyphNameMap Standard = new GlyphNameMap();
    public static final String GLYPH_NOTDEF = ".notdef";
    private static final Logger Log = LoggerFactory.getLogger(GlyphNameMap.class);
    private static final String AdobeGlyphList = "AdobeGlyphList.txt";
    private static final String PREFIX_UNI = "uni";
    private Map glyphNameToUnicode = new HashMap();
    private Map unicodeToGlyphName = new HashMap();
    private String[] asciiToGlyphName = new String[256];

    protected GlyphNameMap() {
        for (int i = 0; i < this.asciiToGlyphName.length; ++i) {
            this.asciiToGlyphName[i] = GLYPH_NOTDEF;
        }
        this.load();
    }

    protected void addEntry(String glyphName, int unicode) {
        this.glyphNameToUnicode.put(glyphName, unicode);
        this.unicodeToGlyphName.put(unicode, glyphName);
        if (unicode >= 0 && unicode < 256) {
            this.asciiToGlyphName[unicode] = glyphName;
        }
    }

    public String getGlyphName(int unicode) {
        if (unicode >= 0 && unicode < 256) {
            return this.asciiToGlyphName[unicode];
        }
        String glyphName = (String)this.unicodeToGlyphName.get(unicode);
        if (glyphName == null) {
            return GLYPH_NOTDEF;
        }
        return glyphName;
    }

    protected Map getGlyphNameToUnicode() {
        return this.glyphNameToUnicode;
    }

    public int getUnicode(String glyphName) {
        Integer result = (Integer)this.glyphNameToUnicode.get(glyphName);
        if (result == null && glyphName != null && glyphName.startsWith(PREFIX_UNI)) {
            try {
                result = Integer.parseInt(glyphName.substring(3), 16);
                this.addEntry(glyphName, result);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (result == null) {
            return -1;
        }
        return result;
    }

    protected Map getUnicodeToGlyphName() {
        return this.unicodeToGlyphName;
    }

    protected void load() {
        try (InputStream is = this.getClass().getResourceAsStream(AdobeGlyphList);){
            this.load(is);
        }
        catch (IOException e) {
            Log.warn("error loading Adobe glyph list");
        }
    }

    protected void load(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        String name = null;
        String value = null;
        int i = is.read();
        while (i != -1) {
            if (i != 13 && i != 10 && i != 32) {
                if (i == 35) {
                    i = is.read();
                    while (i != -1 && i != 10) {
                        i = is.read();
                    }
                } else {
                    while (i != -1) {
                        if (i == 59) {
                            name = sb.toString();
                            sb.setLength(0);
                        } else {
                            if (i == 32 || i == 13 || i == 10) {
                                value = sb.toString();
                                sb.setLength(0);
                                while (i != -1 && i != 10) {
                                    i = is.read();
                                }
                                break;
                            }
                            sb.append((char)i);
                        }
                        i = is.read();
                    }
                    this.addEntry(name, Integer.parseInt(value, 16));
                }
            }
            i = is.read();
        }
    }
}

