/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.crypt.AESCryptHandler256;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ICryptHandler;
import de.intarsys.pdf.crypt.IdentityCryptHandler;
import de.intarsys.pdf.crypt.StandardCryptHandler;
import de.intarsys.pdf.crypt.SystemSecurityHandler;
import de.intarsys.pdf.filter.Filter;
import java.util.HashMap;
import java.util.Map;

public class SystemSecurityHandlerV5
extends SystemSecurityHandler {
    public static final COSName CN_AESV2 = COSName.constant("AESV2");
    public static final COSName CN_AESV3 = COSName.constant("AESV3");
    public static final COSName CN_CryptFilter = COSName.constant("CryptFilter");
    public static final COSName DK_CFM = COSName.constant("CFM");
    public static final COSName DK_TYPE = COSName.constant("Type");
    public static final COSName DK_NAME = COSName.constant("Name");
    private Map<COSName, ICryptHandler> cryptHandlers = new HashMap<COSName, ICryptHandler>();

    protected SystemSecurityHandlerV5(COSDictionary dict) {
        super(dict);
    }

    public void cosAddCryptFilter(COSName name, COSDictionary cryptFilterDict) {
        COSDictionary encryptDict = this.cosGetEncryption();
        COSDictionary cryptFilters = encryptDict.get(COSEncryption.DK_CF).asDictionary();
        if (cryptFilters == null) {
            cryptFilters = COSDictionary.create();
            encryptDict.put(COSEncryption.DK_CF, cryptFilters);
        }
        cryptFilters.put(name, cryptFilterDict);
    }

    protected COSDictionary createCryptFilterAES() {
        COSDictionary cryptFilterDict = COSDictionary.create();
        cryptFilterDict.put(DK_TYPE, CN_CryptFilter);
        cryptFilterDict.put(DK_CFM, CN_AESV3);
        cryptFilterDict.put(COSName.constant("AuthEvent"), COSName.constant("DocOpen"));
        cryptFilterDict.put(COSEncryption.DK_Length, COSInteger.create(256));
        return cryptFilterDict;
    }

    private ICryptHandler createCryptHandler(COSName name) throws COSSecurityException {
        if (COSEncryption.CN_IDENTITY.equals(name)) {
            return new IdentityCryptHandler();
        }
        COSDictionary dict = this.getEncryption().getCryptFilterDict(name);
        if (dict == null) {
            return new IdentityCryptHandler();
        }
        COSName method = dict.get(DK_CFM).asName();
        if (CN_AESV2.equals(method)) {
            AESCryptHandler256 result = new AESCryptHandler256();
            ((StandardCryptHandler)result).initialize(this.getSecurityHandler().getCryptKey());
            return result;
        }
        if (CN_AESV3.equals(method)) {
            AESCryptHandler256 result = new AESCryptHandler256();
            ((StandardCryptHandler)result).initialize(this.getSecurityHandler().getCryptKey());
            return result;
        }
        return this.getSecurityHandler();
    }

    @Override
    public byte[] decryptFile(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        COSName cosName = this.getEncryption().getCryptFilterNameFile();
        ICryptHandler handler = this.getCryptHandler(cosName);
        byte[] result = handler.decrypt(key, bytes);
        return result;
    }

    @Override
    public byte[] decryptStream(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        COSName name = COSEncryption.CN_IDENTITY;
        if (COSStream.hasFilter(dict, Filter.CN_Filter_Crypt)) {
            COSName paramName;
            COSDictionary decodeParams = COSStream.getDecodeParams(dict, Filter.CN_Filter_Crypt);
            if (decodeParams != null && (paramName = decodeParams.get(DK_NAME).asName()) != null) {
                name = paramName;
            }
        } else {
            name = this.getEncryption().getCryptFilterNameString();
        }
        ICryptHandler handler = this.getCryptHandler(name);
        byte[] result = handler.decrypt(key, bytes);
        return result;
    }

    @Override
    public byte[] decryptString(COSObjectKey key, byte[] bytes) throws COSSecurityException {
        COSName name = this.getEncryption().getCryptFilterNameString();
        ICryptHandler handler = this.getCryptHandler(name);
        byte[] result = handler.decrypt(key, bytes);
        return result;
    }

    @Override
    public byte[] encryptFile(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        COSName name = this.getEncryption().getCryptFilterNameFile();
        ICryptHandler handler = this.getCryptHandler(name);
        byte[] result = handler.encrypt(key, bytes);
        return result;
    }

    @Override
    public byte[] encryptStream(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        if (!this.isEnabled()) {
            return bytes;
        }
        COSName name = COSEncryption.CN_IDENTITY;
        if (COSStream.hasFilter(dict, Filter.CN_Filter_Crypt)) {
            COSName paramName;
            COSDictionary decodeParams = COSStream.getDecodeParams(dict, Filter.CN_Filter_Crypt);
            if (decodeParams != null && (paramName = decodeParams.get(DK_NAME).asName()) != null) {
                name = paramName;
            }
        } else {
            name = this.getEncryption().getCryptFilterNameString();
        }
        ICryptHandler handler = this.getCryptHandler(name);
        byte[] result = handler.encrypt(key, bytes);
        return result;
    }

    @Override
    public byte[] encryptString(COSObjectKey key, byte[] bytes) throws COSSecurityException {
        if (!this.isEnabled()) {
            return bytes;
        }
        COSName name = this.getEncryption().getCryptFilterNameString();
        ICryptHandler handler = this.getCryptHandler(name);
        byte[] result = handler.encrypt(key, bytes);
        return result;
    }

    public ICryptHandler getCryptHandler(COSName name) throws COSSecurityException {
        ICryptHandler cryptHandler = this.cryptHandlers.get(name);
        if (cryptHandler == null) {
            cryptHandler = this.createCryptHandler(name);
            this.cryptHandlers.put(name, cryptHandler);
        }
        return cryptHandler;
    }

    @Override
    public int getLength() {
        return 256;
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Override
    protected void initializeFromScratch() {
        COSEncryption encryption = this.getEncryption();
        encryption.setFieldInt(COSEncryption.DK_Length, 256);
        encryption.cosSetField(COSEncryption.DK_V, COSInteger.create(this.getVersion()));
        COSName standardFilterName = COSName.constant("StdCF");
        this.setEncryptionMethodAES(standardFilterName);
        this.setEncryptionFilterStream(standardFilterName);
        this.setEncyptionFilterString(standardFilterName);
        this.setEncryptMetadata(true);
    }

    public void setEncryptionFilterStream(COSName name) {
        COSDictionary encryptDict = this.cosGetEncryption();
        encryptDict.put(COSEncryption.DK_StmF, name);
    }

    public void setEncryptionMethodAES(COSName filterName) {
        this.cosAddCryptFilter(filterName, this.createCryptFilterAES());
    }

    public void setEncryptMetadata(boolean value) {
        COSDictionary encryptDict = this.cosGetEncryption();
        encryptDict.put(COSEncryption.DK_EncryptMetadata, COSBoolean.create(value));
    }

    public void setEncyptionFilterString(COSName standardFilterName) {
        COSDictionary encryptDict = this.cosGetEncryption();
        encryptDict.put(COSEncryption.DK_StrF, standardFilterName);
    }
}

