/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.IAccessPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public final class AccessPermissionChain
implements IAccessPermissions {
    private final List<IAccessPermissions> chain = new ArrayList<IAccessPermissions>();

    public void add(IAccessPermissions accessPermissions) {
        this.chain.add(accessPermissions);
    }

    protected boolean checkByChain(Predicate<IAccessPermissions> test) {
        Optional<IAccessPermissions> negative = this.getChain().stream().filter(e -> !test.test((IAccessPermissions)e)).findAny();
        return negative.isEmpty();
    }

    protected List<IAccessPermissions> getChain() {
        return new ArrayList<IAccessPermissions>(this.chain);
    }

    @Override
    public final boolean mayAssemble() {
        return this.checkByChain(IAccessPermissions::mayAssemble);
    }

    @Override
    public final boolean mayCopy() {
        return this.checkByChain(IAccessPermissions::mayCopy);
    }

    @Override
    public final boolean mayExtract() {
        return this.checkByChain(IAccessPermissions::mayExtract);
    }

    @Override
    public final boolean mayFillForm() {
        return this.checkByChain(IAccessPermissions::mayFillForm);
    }

    @Override
    public final boolean mayModify() {
        return this.checkByChain(IAccessPermissions::mayModify);
    }

    @Override
    public final boolean mayModifyAnnotation() {
        return this.checkByChain(IAccessPermissions::mayModifyAnnotation);
    }

    @Override
    public final boolean mayPrint() {
        return this.checkByChain(IAccessPermissions::mayPrint);
    }

    @Override
    public final boolean mayPrintHighQuality() {
        return this.checkByChain(IAccessPermissions::mayPrintHighQuality);
    }
}

