/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.StandardCryptHandler;
import de.intarsys.tools.crypto.CryptoTools;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCryptHandler256
extends StandardCryptHandler {
    public static final String KEY_ALGORITHM = "AES";
    public static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final String DIGEST_ALGORITHM = "MD5";
    private int blockSize;

    @Override
    protected synchronized byte[] basicDecrypt(byte[] data, byte[] encryptionKey, int objectNum, int genNum) throws COSSecurityException {
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(data, 0, this.blockSize);
            SecretKeySpec skeySpec = new SecretKeySpec(encryptionKey, 0, encryptionKey.length, KEY_ALGORITHM);
            this.cipher.init(2, (Key)skeySpec, ivSpec);
            return this.cipher.doFinal(data, this.blockSize, data.length - this.blockSize);
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    @Override
    protected synchronized byte[] basicEncrypt(byte[] data, byte[] encryptionKey, int objectNum, int genNum) throws COSSecurityException {
        try {
            byte[] initVector = this.cipher.getIV();
            if (initVector == null) {
                initVector = new byte[16];
            }
            SecureRandom random = CryptoTools.createSecureRandom();
            random.nextBytes(initVector);
            IvParameterSpec ivSpec = new IvParameterSpec(initVector, 0, initVector.length);
            SecretKeySpec skeySpec = new SecretKeySpec(encryptionKey, KEY_ALGORITHM);
            this.cipher.init(1, (Key)skeySpec, ivSpec);
            byte[] encrypted = this.cipher.doFinal(data);
            byte[] result = new byte[initVector.length + encrypted.length];
            System.arraycopy(initVector, 0, result, 0, initVector.length);
            System.arraycopy(encrypted, 0, result, initVector.length, encrypted.length);
            return result;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    @Override
    public void initialize(byte[] pCryptKey) throws COSSecurityException {
        super.initialize(pCryptKey);
        try {
            this.cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            this.blockSize = this.cipher.getBlockSize();
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    @Override
    protected void updateHash(byte[] encryptionKey, int objectNum, int genNum) {
    }
}

