/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.text;

import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSTextDevice;
import de.intarsys.pdf.font.PDGlyphs;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class CSCharacterParser
extends CSTextDevice {
    protected double lastStopX;
    protected double lastStopY;
    protected double lastStartX;
    protected double lastStartY;
    private Shape bounds;

    protected CSCharacterParser() {
    }

    @Override
    protected void basicTextShowGlyphs(PDGlyphs glyphs, float advance) throws CSException {
        AffineTransform tx = (AffineTransform)this.getDeviceTransform().clone();
        tx.concatenate(this.textState.globalTransform);
        this.lastStartX = tx.getTranslateX();
        this.lastStartY = tx.getTranslateY();
        double glyphAscent = glyphs.getAscent();
        double glyphDescent = glyphs.getDescent();
        double ascent = (double)this.textState.fontSize * glyphAscent / 1000.0;
        double descent = (double)this.textState.fontSize * glyphDescent / 1000.0;
        if (descent > 0.0) {
            descent = -descent;
        }
        double[] pts = new double[]{0.0, descent, advance, ascent};
        tx.deltaTransform(pts, 0, pts, 0, 2);
        float x = (float)this.lastStartX;
        float y = (float)(this.lastStartY + pts[1]);
        float width = (float)pts[2];
        float height = (float)(pts[3] - pts[1]);
        if (width < 0.0f) {
            x += width;
            width = -width;
        }
        if (height < 0.0f) {
            y += height;
            height = -height;
        }
        Rectangle2D.Float charRect = new Rectangle2D.Float(x, y, width, height);
        if (this.getBounds() == null || this.getBounds().intersects(charRect)) {
            this.onCharacterFound(glyphs, charRect);
        }
        super.basicTextShowGlyphs(glyphs, advance);
        tx = (AffineTransform)this.getDeviceTransform().clone();
        tx.concatenate(this.textState.globalTransform);
        this.lastStopX = tx.getTranslateX();
        this.lastStopY = tx.getTranslateY();
    }

    protected void onCharacterFound(PDGlyphs glyphs, Rectangle2D rect) {
    }

    public Shape getBounds() {
        return this.bounds;
    }

    public void setBounds(Shape bounds) {
        this.bounds = bounds;
    }
}

