/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.common;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.tools.string.StringTools;

public class CSPrettyPrinter {
    private static final int COL_WIDTH = 50;
    private StringBuilder sb;
    private StringBuilder lb;
    private boolean createComment = false;
    private boolean createLineSeparator = true;
    private boolean createIndent = true;
    private String lineSeparator = StringTools.LS;
    private int indent = 0;

    public String getValue() {
        return this.sb.toString();
    }

    public void print(CSContent content) {
        this.sb = new StringBuilder();
        this.lb = new StringBuilder();
        int len = content.size();
        for (int i = 0; i < len; ++i) {
            CSOperation operation = content.getOperation(i);
            this.printOperation(operation);
        }
    }

    protected void printOperation(CSOperation operation) {
        this.lb.setLength(0);
        if (operation.matchesOperator(CSOperators.CSO_Q)) {
            --this.indent;
        }
        if (this.isCreateIndent()) {
            for (int i = 0; i < this.indent; ++i) {
                this.lb.append("   ");
            }
        }
        String opString = operation.toString();
        this.lb.append(opString);
        if (this.isCreateComment()) {
            for (int i = this.lb.length(); i < 50; ++i) {
                this.lb.append(" ");
            }
            this.lb.append("% ");
            String opDescription = CSOperators.getDescription(operation.getOperator());
            this.lb.append(opDescription);
        }
        if (this.isCreateLineSeparator() || this.isCreateComment() || this.isCreateIndent()) {
            this.lb.append(this.lineSeparator);
        } else {
            this.lb.append(" ");
        }
        if (operation.matchesOperator(CSOperators.CSO_q)) {
            ++this.indent;
        }
        this.sb.append((CharSequence)this.lb);
    }

    public boolean isCreateComment() {
        return this.createComment;
    }

    public void setCreateComment(boolean createComment) {
        this.createComment = createComment;
    }

    public boolean isCreateLineSeparator() {
        return this.createLineSeparator;
    }

    public void setCreateLineSeparator(boolean separateLines) {
        this.createLineSeparator = separateLines;
    }

    public boolean isCreateIndent() {
        return this.createIndent;
    }

    public void setCreateIndent(boolean createIndent) {
        this.createIndent = createIndent;
    }
}

