/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.decorate;

import de.intarsys.processor.decorate.CommonPreprocessor;
import de.intarsys.processor.model.IProcessor;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.List;

public class PreprocessorTools {
    protected static IProcessor createInstance(Object preprocessorObj) throws ObjectCreationException {
        InstanceSpec<IProcessor> spec = PreprocessorTools.createInstanceSpec(preprocessorObj);
        if (spec == null) {
            return null;
        }
        IProcessor processor = (IProcessor)spec.createInstance();
        return processor;
    }

    protected static InstanceSpec<IProcessor> createInstanceSpec(Object preprocessorObj) {
        InstanceSpec spec;
        if (preprocessorObj instanceof IArgs) {
            InstanceSpec tempSpec;
            IArgs tempArgs = (IArgs)preprocessorObj;
            if (tempArgs.get("factory") == null && (tempSpec = InstanceSpec.get((IArgs)tempArgs, (String)"processor", Object.class, null)) != null) {
                preprocessorObj = tempSpec;
                tempSpec.putInto(tempArgs);
            }
            InstanceSpec.put((IArgs)tempArgs, (String)"processor", null);
        }
        if ((spec = InstanceSpec.toInstanceSpec((Object)preprocessorObj, IProcessor.class)).getFactory() == null) {
            return null;
        }
        return spec;
    }

    protected static List<IFactory> getPreprocessorFactories(IArgs args) throws ObjectCreationException {
        ArrayList<IFactory> result = new ArrayList<IFactory>();
        IArgs preprocessorsArgs = ArgTools.getArgs((IArgs)args, (String)"preprocessors", (IArgs)Args.create());
        for (int i = 0; i < preprocessorsArgs.size(); ++i) {
            Object preprocessorObj = preprocessorsArgs.get(i);
            InstanceSpec<IProcessor> spec = PreprocessorTools.createInstanceSpec(preprocessorObj);
            if (spec == null) continue;
            result.add(spec.getRealFactory());
        }
        return result;
    }

    public static List<IProcessor> getPreprocessors(Object target, IArgs args) throws ObjectCreationException {
        ArrayList<IProcessor> result = new ArrayList<IProcessor>();
        IArgs preprocessorsArgs = ArgTools.getArgs((IArgs)args, (String)"preprocessors", (IArgs)Args.create());
        for (int i = 0; i < preprocessorsArgs.size(); ++i) {
            Object preprocessorObj = preprocessorsArgs.get(i);
            IProcessor processor = PreprocessorTools.createInstance(preprocessorObj);
            if (processor == null) continue;
            if (processor instanceof CommonPreprocessor) {
                ((CommonPreprocessor)processor).setBaseProcessor(target);
            }
            result.add(processor);
        }
        return result;
    }

    public static boolean isPreprocessorSelected(IFactory factory, IArgs baseProcessorArgs) {
        List<IFactory> preprocessors;
        try {
            preprocessors = PreprocessorTools.getPreprocessorFactories(baseProcessorArgs);
        }
        catch (ObjectCreationException e) {
            return false;
        }
        for (IFactory preprocessor : preprocessors) {
            if (preprocessor != factory) continue;
            return true;
        }
        return false;
    }

    public static void preprocess(Object target, IArgs args) throws ObjectCreationException, FunctorException {
        List<IProcessor> preprocessors = PreprocessorTools.getPreprocessors(target, args);
        for (IProcessor preprocessor : preprocessors) {
            FunctorTools.asResult((Object)preprocessor);
        }
    }

    private PreprocessorTools() {
    }
}

