/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.device;

import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.jca.device.DevicePrivateKey;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.streaming.StreamingTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceKeyStoreSpi
extends KeyStoreSpi {
    private static final Logger Log = LoggerFactory.getLogger(DeviceKeyStoreSpi.class);
    private IDevice device;

    public DeviceKeyStoreSpi(IDevice device) {
        this.device = device;
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.getPrincipalStream().map(principal -> principal.getId()).collect(Collectors.toList()));
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.getPrincipal(alias).isPresent();
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new KeyStoreException("KeyStore is read-only");
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Optional<IX509Principal> principal = this.getPrincipal(alias);
        return principal.map(obj -> obj.getJavaCertificate()).orElse(null);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return this.getPrincipalStream().filter(principal -> cert.equals(principal.getJavaCertificate())).findFirst().map(principal -> principal.getId()).orElse(null);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        IX509Certificate[] certificatePath;
        IX509PublicKeyCertificate certificate;
        Optional<IX509Principal> principal = this.getPrincipal(alias);
        if (principal.isPresent() && (certificate = principal.get().getX509PublicKeyCertificate()) != null && (certificatePath = ValidationTools.getCertificatePath((IX509Certificate)certificate, (boolean)true)) != null) {
            try {
                return CertificateTools.toJavaCerts((IX509Certificate[])certificatePath);
            }
            catch (CertificateException e) {
                Log.warn(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return new Date();
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        Optional<IX509Principal> principal = this.getPrincipal(alias);
        if (!principal.isPresent()) {
            return null;
        }
        return DevicePrivateKey.create(this.device, principal.get(), Secret.hide((char[])password));
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.engineContainsAlias(alias);
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("KeyStore is read-only");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("KeyStore is read-only");
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("KeyStore is read-only");
    }

    @Override
    public int engineSize() {
        return 1;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws CertificateException {
        throw new CertificateException("KeyStore is not serializable");
    }

    protected Optional<IX509Principal> getPrincipal(String id) {
        return this.getPrincipalStream().filter(principal -> id.equals(principal.getId())).findFirst();
    }

    protected Stream<IX509Principal> getPrincipalStream() {
        IPrincipalFilter principalFilter = principal -> principal instanceof IX509Principal;
        return StreamingTools.asStream(this.device.listPrincipals(principalFilter)).map(IX509Principal.class::cast);
    }
}

