/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.software.device;

import de.intarsys.security.algorithm.rsa.RsaTools;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.CommonSingleSigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.Cipher;

public class SoftwareSigner
extends CommonSingleSigner {
    public static final Collection<String> SUPPORTED_DIGEST_ALGORITHMS = Arrays.asList("MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512", "RIPEMD160", "RIPEMD256");
    private final PrivateKey privateKey;

    public SoftwareSigner(CommonDevice device, PrivateKey privateKey) throws ObjectCreationException {
        super(device);
        this.privateKey = privateKey;
        try {
            this.authenticate().get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected IConversation<ISignatureData> basicSignSingle(IToBeSignedData data) {
        try {
            Cipher rsaCipher = RsaTools.lookupRSACipher((String)"BC");
            rsaCipher.init(1, this.getPrivateKey());
            byte[] signature = rsaCipher.doFinal(data.getEncodedDigest());
            return Conversation.completed((Object)SignatureData.create((byte[])signature));
        }
        catch (GeneralSecurityException e) {
            return Conversation.failed((Throwable)new SecurityApplicationException(e));
        }
    }

    @Override
    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return null;
    }

    @Override
    public String getEncryptionAlgorithmName() {
        return "RSA";
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_DIGEST_ALGORITHMS;
    }

    @Override
    public boolean isBasic() {
        return true;
    }
}

