/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.key;

import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.creation.X509PublicKeyCertificateCreator;
import de.intarsys.security.certificate.creation.X509PublicKeyCertificateCreatorFactory;
import de.intarsys.security.device.key.CertificateSigner;
import de.intarsys.security.device.key.IPublicKeyCertifier;
import de.intarsys.security.privatekey.KeyCertificatePair;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.security.KeyPair;
import java.security.PublicKey;

public class CertificateCreator
implements IPublicKeyCertifier {
    public static final String ARG_SIGNER = "signer";
    public static final String ARG_CERTIFIER = "certifier";
    private IArgs args;

    public CertificateCreator(IArgs args) {
        this.args = args;
    }

    @Override
    public IX509PublicKeyCertificate certify(PublicKey publicKey, Throwing.Specific.Supplier<ISigner, Exception> privateKeySigner) throws SecurityApplicationException {
        try {
            InstanceSpec signerSpec = InstanceSpec.get((IArgs)this.getArgs(), (String)ARG_SIGNER, ISigner.class, null);
            ISigner signer = signerSpec == null ? (ISigner)privateKeySigner.get() : (ISigner)signerSpec.createInstance();
            if (!signer.isBasic()) {
                throw new IllegalStateException("signer must be on basic level");
            }
            try {
                ((IAuthenticatedApplication)((Object)signer)).authenticate().get();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot authenticate with signer app: " + e.getMessage(), e);
            }
            CertificateSigner certificateSigner = new CertificateSigner(signer);
            InstanceSpec certifierSpec = InstanceSpec.get((IArgs)this.getArgs(), (String)ARG_CERTIFIER, X509PublicKeyCertificateCreator.class, null);
            Object certifierArgs = null;
            certifierArgs = certifierSpec == null ? Args.create() : certifierSpec.getArgs().copy();
            ArgTools.putPath((IArgs)certifierArgs, (String)"certificateSigner", (Object)certificateSigner);
            X509PublicKeyCertificateCreator certificateCreator = (X509PublicKeyCertificateCreator)FactoryTools.createInstance(X509PublicKeyCertificateCreatorFactory.class, (IArgs)certifierArgs);
            certificateCreator.setKeyPair(new KeyPair(publicKey, null));
            KeyCertificatePair keyPair = certificateCreator.createEntity();
            return keyPair.getCertificate();
        }
        catch (Exception e) {
            throw new SecurityApplicationException(e);
        }
    }

    public IArgs getArgs() {
        return this.args;
    }
}

