/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IAccessSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class CommonPrincipal
implements IPrincipal,
IAccessSupport {
    private final AttributeMap attributes = new AttributeMap();
    private final EventDispatcher eventDispatcher = new EventDispatcher((Object)this);
    private final String id;
    private final IDevice device;
    protected final Object lock = new Object();
    private final Map<String, Object> values = new HashMap<String, Object>();
    private final List<INotice> notices = new CopyOnWriteArrayList<INotice>();

    public CommonPrincipal(IDevice device, String id) {
        this.device = device;
        assert (id != null);
        this.id = id;
    }

    public void addNotice(INotice notice) {
        this.notices.add(notice);
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"notices", null, (Object)notice));
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.eventDispatcher.addNotificationListener(type, listener);
    }

    public void clearNotices() {
        this.notices.clear();
        this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"notices", null, null));
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    protected AttributeMap getAttributes() {
        return this.attributes;
    }

    @Override
    public IDevice getDevice() {
        return this.device;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<INotice> getNotices() {
        return this.notices;
    }

    public Object getValue(String name) throws FieldException {
        return this.values.get(name);
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public boolean removeNotice(INotice notice) {
        if (this.notices.remove(notice)) {
            this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"notices", (Object)notice, null));
            return true;
        }
        return false;
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.eventDispatcher.removeNotificationListener(type, listener);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public Object setValue(String name, Object value) throws FieldException {
        return null;
    }

    @Override
    public boolean supportsApplication(String id) {
        return true;
    }

    protected void triggerEvent(Event event) {
        this.eventDispatcher.triggerEvent(event);
    }
}

