/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.ssl;

import de.intarsys.security.app.ssl.DeviceBasedKeyManager;
import de.intarsys.security.device.IDevice;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.ssl.ConfigurableKeyManagerProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceBasedKeyManagerProvider
extends ConfigurableKeyManagerProvider {
    private static final Logger Log = LoggerFactory.getLogger(DeviceBasedKeyManagerProvider.class);
    private IDevice signerDevice;
    private IArgs signerArgs;

    public static DeviceBasedKeyManagerProvider create() {
        return new DeviceBasedKeyManagerProvider();
    }

    public KeyManager[] createKeyManagers() throws GeneralSecurityException, IOException {
        KeyManager[] managers = null;
        if (this.getSignerDevice() == null) {
            managers = super.createKeyManagers();
        } else {
            Log.debug("{} SSLContext will use explicit key from device {}", (Object)this, (Object)this.getSignerDevice().getId());
            try {
                managers = new KeyManager[]{DeviceBasedKeyManager.create(this.getSignerDevice(), this.getSignerArgs())};
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e);
            }
        }
        return managers;
    }

    public IArgs getSignerArgs() {
        return this.signerArgs;
    }

    public IDevice getSignerDevice() {
        return this.signerDevice;
    }

    public void setSignerArgs(IArgs signerArgs) {
        this.signerArgs = signerArgs;
    }

    public void setSignerDevice(IDevice signerDevice) {
        this.signerDevice = signerDevice;
    }
}

