/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.common.DelegatingSecurityApplication;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.method.common.signature.SignatureOptions;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.ISignatureDataList;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;

public abstract class DelegatingSigner<T extends ISigner>
extends DelegatingSecurityApplication<T>
implements ISigner {
    protected DelegatingSigner(IDevice device, T wrapped) {
        super(device, wrapped);
    }

    @Override
    public void buildCertificatePath() {
        ((ISigner)this.getWrapped()).buildCertificatePath();
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return ((ISigner)this.getWrapped()).getAlgorithmParameterSpec();
    }

    @Override
    public int getApproximatedContainerSize() {
        return ((ISigner)this.getWrapped()).getApproximatedContainerSize();
    }

    @Override
    public IX509PublicKeyCertificate[] getCertificatePath() {
        return ((ISigner)this.getWrapped()).getCertificatePath();
    }

    @Override
    public String getEncryptionAlgorithmName() {
        return ((ISigner)this.getWrapped()).getEncryptionAlgorithmName();
    }

    @Override
    public String getHashAlgorithmName() {
        return ((ISigner)this.getWrapped()).getHashAlgorithmName();
    }

    @Override
    public String getPreferredHashAlgorithmName() {
        return ((ISigner)this.getWrapped()).getPreferredHashAlgorithmName();
    }

    @Override
    public IPrincipal getPrincipal() {
        return ((ISigner)this.getWrapped()).getPrincipal();
    }

    @Override
    public SignatureFormat getSignatureFormat() {
        return ((ISigner)this.getWrapped()).getSignatureFormat();
    }

    @Override
    public Collection<String> getSupportedHashAlgorithmNames() {
        return ((ISigner)this.getWrapped()).getSupportedHashAlgorithmNames();
    }

    @Override
    public boolean isBasic() {
        return ((ISigner)this.getWrapped()).isBasic();
    }

    @Override
    public void setHashAlgorithmName(String name) throws SecurityApplicationException {
        ((ISigner)this.getWrapped()).setHashAlgorithmName(name);
    }

    @Override
    public void setSignatureFormat(SignatureFormat family) {
        ((ISigner)this.getWrapped()).setSignatureFormat(family);
    }

    @Override
    public void setSignatureOptions(SignatureOptions options) {
        ((ISigner)this.getWrapped()).setSignatureOptions(options);
    }

    @Override
    public IConversation<ISignatureData> sign(IToBeSignedData data) {
        try {
            this.checkDispose();
        }
        catch (SecurityApplicationException e) {
            return Conversation.failed((Throwable)e);
        }
        return ((ISigner)this.getWrapped()).sign(data);
    }

    @Override
    public IConversation<Void> signAbort() {
        return ((ISigner)this.getWrapped()).signAbort();
    }

    @Override
    public IConversation<Void> signBegin() {
        return ((ISigner)this.getWrapped()).signBegin();
    }

    @Override
    public IConversation<ISignatureDataList> signCommit() {
        return ((ISigner)this.getWrapped()).signCommit();
    }

    @Override
    public IConversation<Void> signPrepare() {
        return ((ISigner)this.getWrapped()).signPrepare();
    }
}

