/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.common;

import de.intarsys.security.app.ApplicationException;
import de.intarsys.security.app.AuthenticationExceptionEvent;
import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.common.AbstractApplication;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.app.common.PACKAGE;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.activity.IPrompter;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.authenticate.PasswordProvider;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.crypto.SecretStore;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.ui.toolkit.Toolkit;
import de.intarsys.tools.validation.IValidationResult;
import de.intarsys.tools.validation.ValidationTools;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonSecurityApplicationFactory<D extends CommonDevice, T extends CommonSecurityApplication>
implements IFactory<T>,
IApplicationDescriptor {
    private static final Logger Log = LoggerFactory.getLogger(CommonSecurityApplicationFactory.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private CommonDeviceProvider<?> deviceProvider;
    private Class type;
    private IApplicationPolicy<T> policy;
    private Supplier<ILicenseAccount> licenseAccountSupplier;

    protected CommonSecurityApplicationFactory() {
    }

    protected T basicCreateApp(IArgs args) throws ObjectCreationException {
        return null;
    }

    protected void basicInitApp(T app, IArgs args) throws ObjectCreationException {
    }

    protected void clearSecret(IX509PublicKeyCertificate cert) {
        String id = CertificateTools.getUniqueIdentifier((IX509PublicKeyCertificate)cert);
        SecretStore.get().clearSecret(id);
    }

    public T createInstance(IArgs args) throws ObjectCreationException {
        T app = this.basicCreateApp(args);
        if (app != null) {
            this.basicInitApp(app, args);
            ((AbstractApplication)app).setDescriptor(this);
            ((AbstractApplication)app).init();
            ((CommonSecurityApplication)app).setLicenseAccount(this.getLicenseAccount());
            if (this.getPolicy() != null) {
                IValidationResult result = this.getPolicy().validate(app);
                for (INotice notice : result.getNotices()) {
                    if (notice.getSeverity() != 30 && notice.getSeverity() != 20) continue;
                    ((CommonDevice)this.getDevice(args)).sendNotification(notice);
                }
                if (!result.getNotices().isEmpty()) {
                    String summary = ValidationTools.getSummary((IValidationResult)result, (int)20);
                    if (result.hasError()) {
                        Log.error(summary);
                        ((AbstractApplication)app).dispose();
                        throw new ObjectCreationException(summary);
                    }
                    if (result.hasWarning()) {
                        Log.warn(summary);
                    }
                }
            }
        }
        return app;
    }

    protected String getArgNamePassword() {
        return null;
    }

    protected String getAuthenticationPrompt(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)"authenticationPrompt", null);
    }

    protected IX509PublicKeyCertificate getCertificate(IArgs args, String name) throws ObjectCreationException {
        ICertificateProvider provider = this.getCertificateProvider(args);
        IX509PublicKeyCertificate certificate = (IX509PublicKeyCertificate)CertificateProviderTools.getCertificate((IArgs)args, (String)name, (ICertificateProvider)provider);
        return certificate;
    }

    protected ICertificateProvider getCertificateProvider(IArgs args) throws ObjectCreationException {
        ICertificateProvider provider = CertificateProviderTools.getCertificateProvider((IArgs)args, (String)"signerStore", (ICertificateProvider)IdCertificateProvider.get());
        return provider;
    }

    protected D getDevice(IArgs args) {
        return (D)((CommonDevice)args.get("device"));
    }

    public CommonDeviceProvider<?> getDeviceProvider() {
        return this.deviceProvider;
    }

    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public ILicenseAccount getLicenseAccount() {
        return this.getLicenseAccountSupplier() == null ? null : this.getLicenseAccountSupplier().get();
    }

    public Supplier<ILicenseAccount> getLicenseAccountSupplier() {
        return this.licenseAccountSupplier;
    }

    protected String getLogPrefix() {
        return "application factory " + this.getId();
    }

    @Override
    public List<String> getOperations(IDevice device) throws ApplicationException {
        return null;
    }

    protected IPasswordProvider getPasswordProvider(IArgs args) {
        IPasswordProvider passwordProvider = (IPasswordProvider)ArgTools.getObject((IArgs)args, (String)"passwordProvider", (Object)PasswordProvider.get());
        return passwordProvider;
    }

    public IApplicationPolicy<T> getPolicy() {
        return this.policy;
    }

    public Class<T> getResultType() {
        return CommonSecurityApplication.class;
    }

    public Secret getSecret(IArgs args, String name, Supplier<String> keySupplier) {
        Secret secret = null;
        if (this.isAllowedSecretFromAPI() && !CryptoTools.isEmpty((Secret)(secret = ArgTools.getSecretHide((IArgs)args, (String)name, (Secret)Secret.EMPTY)))) {
            Log.debug("{} receive secret from API", (Object)this.getLogPrefix());
        }
        if (CryptoTools.isEmpty(secret) && this.isAllowedSecretFromCache() && keySupplier != null) {
            String key = keySupplier.get();
            secret = SecretStore.get().getSecret(key);
            if (!CryptoTools.isEmpty((Secret)secret)) {
                Log.debug("{} receive secret from cache", (Object)this.getLogPrefix());
            }
        }
        return secret;
    }

    public Class getType() {
        return this.type;
    }

    public void initAuthentication(T securityApp, IX509PublicKeyCertificate cert, IArgs args) throws SecurityApplicationException {
        if (!(securityApp instanceof IAuthenticatedApplication)) {
            return;
        }
        securityApp.setAuthenticationPrompt(this.getAuthenticationPrompt(args));
        securityApp.setPasswordProvider(this.getPasswordProvider(args));
        Secret pin = this.getSecret(args, this.getArgNamePassword(), () -> CertificateTools.getUniqueIdentifier((IX509PublicKeyCertificate)cert));
        if (CryptoTools.isEmpty((Secret)pin)) {
            pin = this.initAuthenticationCheckBatch(securityApp, args, cert);
        } else {
            ((AbstractApplication)((Object)securityApp)).addNotificationListener(AuthenticationExceptionEvent.ID, (INotificationListener<AuthenticationExceptionEvent>)((INotificationListener)event -> {
                Log.warn("{} secret invalid, clear cache", (Object)this.getLogPrefix());
                this.clearSecret(cert);
            }));
        }
        securityApp.setAuthenticationPin(pin);
    }

    protected Secret initAuthenticationCheckBatch(T securityApp, IArgs args, IX509PublicKeyCertificate cert) throws SecurityApplicationException {
        if (!(securityApp instanceof IAuthenticatedApplication)) {
            return null;
        }
        if (this.isAllowedSecretFromCache() && this.isBatch(args) && ((CommonSecurityApplication)securityApp).getRestrictionCount() == 1 && !Toolkit.get().isSilent()) {
            Secret pin;
            IMessage msg = Msg.getMessage("CommonSecurityApplicationFactory.NoBatchCard", new Object[0]);
            if (securityApp.getPasswordProvider() instanceof IPrompter) {
                ((IPrompter)securityApp.getPasswordProvider()).setMessage(msg);
            }
            if (CryptoTools.isEmpty((Secret)(pin = securityApp.getPasswordProvider().getPassword()))) {
                msg = Msg.getMessage("CommonSecurityApplicationFactory.ErrorNoBatchCard", new Object[0]);
                throw new SecurityApplicationException(msg.getString());
            }
            return pin;
        }
        return null;
    }

    protected boolean isAllowedSecretFromAPI() {
        return ((CommonDeviceProvider)this.getDeviceProvider()).isAllowSecretFromAPI();
    }

    protected boolean isAllowedSecretFromCache() {
        return ((CommonDeviceProvider)this.getDeviceProvider()).isAllowSecretFromCache();
    }

    protected boolean isBatch(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"batch", (boolean)false);
    }

    public void setDeviceProvider(CommonDeviceProvider<?> deviceProvider) {
        this.deviceProvider = deviceProvider;
    }

    public void setLicenseAccountSupplier(Supplier<ILicenseAccount> licenseAccountSupplier) {
        if (this.licenseAccountSupplier != null) {
            throw new LicenseException("license tampering");
        }
        this.licenseAccountSupplier = licenseAccountSupplier;
    }

    public void setPolicy(IApplicationPolicy<T> policy) {
        this.policy = policy;
    }

    public void setType(Class type) {
        this.type = type;
    }
}

