/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.common;

import de.intarsys.processor.decorate.PreprocessorTools;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.format.Format;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class ApplicationFactory<T extends ISecurityApplication>
implements IFactory<T> {
    private Class<T> applicationType;

    public T createInstance(IArgs args) throws ObjectCreationException {
        Class<T> staticApplicationType = this.getApplicationType();
        Class<T> argApplicationType = ArgTools.getClass((IArgs)args, (String)"type", null);
        if (argApplicationType == null) {
            argApplicationType = staticApplicationType;
        } else if (staticApplicationType != null && !staticApplicationType.isAssignableFrom(argApplicationType)) {
            throw new ObjectCreationException(Format.simple((String)"incompatible types {} and {}", (Object[])new Object[]{staticApplicationType, argApplicationType}));
        }
        if (argApplicationType == null) {
            throw new ObjectCreationException("no type");
        }
        IDevice device = DeviceTools.getDevice(args, "device");
        if (device == null) {
            throw new ObjectCreationException("no device");
        }
        ISecurityApplication app = (ISecurityApplication)device.createApplication(argApplicationType.getName(), args);
        try {
            PreprocessorTools.preprocess((Object)app, (IArgs)args);
        }
        catch (Exception e) {
            app.dispose();
            throw (ObjectCreationException)ExceptionTools.createTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
        return (T)app;
    }

    public Class<T> getApplicationType() {
        return this.applicationType;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public Class<T> getResultType() {
        return this.applicationType;
    }

    public void setApplicationType(Class<T> applicationType) {
        this.applicationType = applicationType;
    }
}

