/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.conversation.impl;

import de.intarsys.tools.component.ExpirationPredicate;
import de.intarsys.tools.component.ExpirationWatchdog;
import de.intarsys.tools.component.ExpireTimeout;
import de.intarsys.tools.component.IExpirationSupport;
import de.intarsys.tools.component.IReferenceCounter;
import de.intarsys.tools.conversation.ConversationExpired;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IConversationRegistry;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.ErrorStage;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.string.Converter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardConversationRegistry
implements IConversationRegistry {
    private static final long EXPIRE_30MIN = 1800000L;
    private static final Logger Log = LoggerFactory.getLogger(StandardConversationRegistry.class);
    private final ExpirationWatchdog watchdog = new ExpirationWatchdog(new ExpirationWatchdog.IResourceHolder(){

        public void expire(IExpirationSupport resource) {
            RegisteredConversation registered = (RegisteredConversation)resource;
            IConversation<?> conversation = registered.getConversation();
            Log.debug("{} expired {}", (Object)StandardConversationRegistry.this, conversation);
            conversation.cancel(false);
            while (registered.getReferenceCount() > 0) {
                StandardConversationRegistry.this.unpublish(conversation);
            }
        }

        public int getResourceCount() {
            return StandardConversationRegistry.this.conversations.size();
        }

        public List<IExpirationSupport> getResources() {
            return new ArrayList<IExpirationSupport>(StandardConversationRegistry.this.conversations.values());
        }
    });
    private long expireTimeout = 1800000L;
    private final ConcurrentHashMap<String, RegisteredConversation> conversations = new ConcurrentHashMap();
    private final Set<String> allowedAttributes = new HashSet<String>();

    public StandardConversationRegistry() {
        this.allowedAttributes.add("tag");
    }

    protected boolean acceptAttributes(IConversation c, Map<String, Object> attributeMap) {
        for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
            if (!this.allowedAttributes.contains(entry.getKey())) {
                return false;
            }
            Object value = c.getAttribute(entry.getKey());
            if (LangTools.equals((Object)entry.getValue(), (Object)value)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.conversations.clear();
    }

    protected String encodeParam(String param) throws UnsupportedEncodingException {
        if (param == null) {
            return null;
        }
        return URLEncoder.encode(param, "UTF-8");
    }

    public IConversation getConversation(String conversationHandle) {
        if (conversationHandle == null) {
            return null;
        }
        RegisteredConversation result = this.conversations.get(conversationHandle);
        if (result == null) {
            throw new ConversationExpired("unknown conversation '" + conversationHandle + "'");
        }
        result.touch();
        return result.getConversation();
    }

    @Override
    public Stream<IConversation<?>> getConversations() {
        return this.conversations.values().stream().map(rc -> rc.getConversation());
    }

    public long getExpireTimeout() {
        return this.expireTimeout;
    }

    @Override
    public IConversation<?> lookupByAttributes(String attributes) {
        try {
            Map attributeMap = Converter.asMap((String)attributes);
            if (attributeMap.isEmpty()) {
                return null;
            }
            return this.conversations.values().stream().map(registered -> registered.conversation).filter(c -> this.acceptAttributes((IConversation)c, attributeMap)).findFirst().orElse(null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("'attributes' invalid", ExceptionTools.unwrap((Throwable)e));
        }
    }

    @Override
    public void publish(IConversation<?> conversation) {
        RegisteredConversation registered = this.conversations.compute(conversation.getHandle(), (key, value) -> {
            if (value == null) {
                int newSize = this.conversations.size() + 1;
                Log.debug("{} published {} (size {})", new Object[]{this, conversation, newSize});
                value = new RegisteredConversation(conversation);
            }
            value.acquire();
            return value;
        });
        IReplyStage stage = conversation.getReplyStage();
        if (stage instanceof ErrorStage) {
            Throwable t = ((ErrorStage)stage).getThrowable();
            Log.warn("conversation {} failed ({})", new Object[]{conversation, ExceptionTools.getMessage((Throwable)t), t});
        }
        registered.touch();
        this.watchdog.wake();
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.watchdog.setCleanupInterval(cleanupInterval);
    }

    public void setExpireTimeout(long expireTimeout) {
        this.expireTimeout = expireTimeout;
    }

    @Override
    public void unpublish(IConversation<?> conversation) {
        this.conversations.computeIfPresent(conversation.getHandle(), (key, value) -> {
            if (value.release()) {
                Log.debug("{} unpublished {} (size {})", new Object[]{this, conversation, this.conversations.size() - 1});
                return null;
            }
            return value;
        });
    }

    class RegisteredConversation
    implements IExpirationSupport {
        private final IConversation<?> conversation;
        private final ExpirationPredicate expiration;
        private final AtomicInteger ref = new AtomicInteger(0);

        RegisteredConversation(IConversation<?> conversation) {
            this.conversation = conversation;
            this.expiration = new ExpireTimeout(StandardConversationRegistry.this.getExpireTimeout());
        }

        public void acquire() {
            if (this.conversation instanceof IReferenceCounter) {
                ((IReferenceCounter)this.conversation).acquire();
            }
            this.ref.incrementAndGet();
        }

        public IConversation<?> getConversation() {
            return this.conversation;
        }

        public ExpirationPredicate getExpiration() {
            return this.expiration;
        }

        public int getReferenceCount() {
            return this.ref.get();
        }

        public boolean isExpired() {
            return this.getExpiration().isExpired();
        }

        public boolean release() {
            if (this.conversation instanceof IReferenceCounter) {
                ((IReferenceCounter)this.conversation).release(null);
            }
            return this.ref.decrementAndGet() == 0;
        }

        public void touch() {
            this.getExpiration().touch();
        }
    }
}

