/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servlet.common;

import de.intarsys.tools.content.IMimeTypeSupport;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ImmutableDelegatingLocator;
import de.intarsys.tools.servlet.common.IResponseCustomizer;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DownloadLocator
extends ImmutableDelegatingLocator
implements IResponseCustomizer,
IMimeTypeSupport {
    private boolean attachment = true;
    private String contentType = null;
    private boolean delete = true;
    private String filename = null;

    public DownloadLocator(ILocator delegate) {
        super(delegate);
    }

    @Override
    public void customize(HttpServletResponse response) {
        if (this.isAttachment()) {
            String tempName = this.getFilename();
            if (tempName == null) {
                tempName = this.getLocator().getName();
            }
            response.setHeader("content-disposition", "attachment; filename=\"" + tempName + "\"");
        }
        if (this.getContentType() != null) {
            response.setContentType(this.getContentType());
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFilename() {
        return this.filename;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isDelete()) {
            return new FilterInputStream(super.getInputStream()){

                @Override
                public void close() throws IOException {
                    super.close();
                    DownloadLocator.this.getLocator().delete();
                }
            };
        }
        return super.getInputStream();
    }

    public boolean isAttachment() {
        return this.attachment;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setAttachment(boolean attachment) {
        this.attachment = attachment;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

