/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.table;

import de.intarsys.tools.table.ITableColumn;
import de.intarsys.tools.table.ITableRecord;
import de.intarsys.tools.table.ITableType;
import de.intarsys.tools.table.TableColumn;
import de.intarsys.tools.table.TableColumnLiteralFunction;
import de.intarsys.tools.table.TableColumnResolverFunction;
import de.intarsys.tools.table.TableRecord;
import java.util.ArrayList;
import java.util.List;

public class TableType
implements ITableType {
    private final List<ITableColumn> columns = new ArrayList<ITableColumn>();
    private String id;

    public TableType() {
    }

    public TableType(String name) {
        this.id = name;
    }

    public void addColumn(ITableColumn column) {
        this.columns.add(column);
    }

    public void addColumnLiteral(String name, String literal) {
        TableColumn column = new TableColumn();
        column.setName(name);
        TableColumnLiteralFunction renderer = new TableColumnLiteralFunction();
        renderer.setLiteral(literal);
        column.setFunction(renderer);
        this.addColumn(column);
    }

    public void addColumnResolver(String name, String expr) {
        TableColumn column = new TableColumn();
        column.setName(name);
        TableColumnResolverFunction renderer = new TableColumnResolverFunction();
        renderer.setExpression(expr);
        column.setFunction(renderer);
        this.addColumn(column);
    }

    public void clearColumns() {
        this.columns.clear();
    }

    @Override
    public ITableRecord createRecord() {
        return new TableRecord(this);
    }

    @Override
    public List<ITableColumn> getColumns() {
        return new ArrayList<ITableColumn>(this.columns);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void removeColumn(TableColumn column) {
        this.columns.remove(column);
    }

    public void setId(String id) {
        this.id = id;
    }
}

