/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.table;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.table.ITableProcessor;
import de.intarsys.tools.table.ITableRecord;
import de.intarsys.tools.table.ITableType;
import de.intarsys.tools.table.TableProcessingException;

public abstract class TableProcessor<R>
implements ITableProcessor<R>,
IElementConfigurable,
IElementSerializable {
    private ITableType activeType;
    private ITableProcessor<R> chainedProcessor;

    @Override
    public void close() throws TableProcessingException {
        if (this.getChainedProcessor() != null) {
            this.getChainedProcessor().close();
        }
        this.activeType = null;
    }

    public void configure(IElement element) throws ConfigurationException {
    }

    public ITableType getActiveType() {
        return this.activeType;
    }

    public ITableProcessor<R> getChainedProcessor() {
        return this.chainedProcessor;
    }

    protected ITableType getChainedType() {
        return this.activeType;
    }

    @Override
    public void open(ITableType type) throws TableProcessingException {
        this.activeType = type;
        if (this.getChainedProcessor() != null) {
            this.getChainedProcessor().open(this.getChainedType());
        }
    }

    @Override
    public R process(ITableRecord item) throws TableProcessingException {
        if (this.getChainedProcessor() != null) {
            return this.getChainedProcessor().process(item);
        }
        return (R)item;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("class", this.getClass().getName());
    }

    public void setChainedProcessor(ITableProcessor<R> chainedProcessor) {
        this.chainedProcessor = chainedProcessor;
    }
}

