/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.NumericFormat;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class PercentFormat
extends NumericFormat {
    public static final String TYPE = "percent";
    public static final String EXT_PERCENT_FORMAT = "EXTPercent_Format";
    public static final String EXT_PERCENT_KEYSTROKE = "EXTPercent_Keystroke";

    public PercentFormat() {
    }

    public PercentFormat(int decimals, int separator) {
        super(decimals, separator);
    }

    protected String createScript(String method, boolean appendScript) {
        StringBuilder script = new StringBuilder();
        if (appendScript) {
            script.append(this.loadFunctionScript()).append(StringTools.LS);
        }
        script.append(method);
        script.append("(").append(this.getDecimals()).append(",").append(this.getSeparator()).append(");");
        return script.toString();
    }

    @Override
    protected void generateScripts() {
        if (this.getSeparator() > 3) {
            this.setFormatScript(this.createScript(EXT_PERCENT_FORMAT, true));
            this.setKeyStrokeScript(this.createScript(EXT_PERCENT_KEYSTROKE, true));
        } else {
            this.setFormatScript(this.createScript("AFPercent_Format", false));
            this.setKeyStrokeScript(this.createScript("AFPercent_Keystroke", false));
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    protected String loadFunctionScript() {
        InputStream is = this.getClass().getResourceAsStream("EXTPercentFormat.js");
        try {
            return StreamTools.getString((InputStream)is, (Charset)null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

