/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.CommonScriptBasedObject;
import de.intarsys.pdf.design.widget.format.CustomFormat;
import de.intarsys.pdf.design.widget.format.DateFormat;
import de.intarsys.pdf.design.widget.format.FunctionParser;
import de.intarsys.pdf.design.widget.format.IScriptBasedObject;
import de.intarsys.pdf.design.widget.format.JSFieldTools;
import de.intarsys.pdf.design.widget.format.NullFormat;
import de.intarsys.pdf.design.widget.format.NumberFormat;
import de.intarsys.pdf.design.widget.format.PercentFormat;
import de.intarsys.pdf.design.widget.format.SpecialFormat;
import de.intarsys.pdf.design.widget.format.TimeFormat;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAdditionalActions;

public abstract class FieldFormat
extends CommonScriptBasedObject {
    private String formatScript = "";
    private String keyStrokeScript = "";
    public static final String[] TYPES = new String[]{"none", "number", "percent", "date", "time", "special", "custom"};
    protected static final FieldFormat NULLFORMAT = new NullFormat();

    public static FieldFormat createNew(String type) {
        if ("none".equals(type)) {
            return new NullFormat();
        }
        if ("number".equals(type)) {
            return new NumberFormat();
        }
        if ("percent".equals(type)) {
            return new PercentFormat();
        }
        if ("date".equals(type)) {
            return new DateFormat();
        }
        if ("time".equals(type)) {
            return new TimeFormat();
        }
        if ("special".equals(type)) {
            return new SpecialFormat();
        }
        if ("custom".equals(type)) {
            return new CustomFormat();
        }
        return null;
    }

    protected static FieldFormat chooseFormat(FieldFormat format, FieldFormat keystroke) {
        if (format.equals(keystroke)) {
            return format;
        }
        if (format.getType().equals("none") && keystroke.getType().equals("special")) {
            return keystroke;
        }
        return new CustomFormat();
    }

    public static FieldFormat createFromField(PDAcroFormField field) {
        field = field.getLogicalRoot();
        String formatScript = JSFieldTools.getJavaScript(field, PDAdditionalActions.CN_trigger_F);
        String keystrokeScript = JSFieldTools.getJavaScript(field, PDAdditionalActions.CN_trigger_K);
        return FieldFormat.createFromScript(formatScript, keystrokeScript);
    }

    public static FieldFormat createFromScript(String formatScript, String keystrokeScript) {
        FieldFormat format = NULLFORMAT;
        if (formatScript != null) {
            format = FunctionParser.parseFormat(formatScript);
        }
        FieldFormat keystroke = NULLFORMAT;
        if (keystrokeScript != null) {
            keystroke = FunctionParser.parseKeystroke(keystrokeScript);
        }
        format = FieldFormat.chooseFormat(format, keystroke);
        if (formatScript != null) {
            format.setFormatScript(formatScript);
        }
        if (keystrokeScript != null) {
            format.setKeyStrokeScript(keystrokeScript);
        }
        return format;
    }

    protected FieldFormat() {
    }

    @Override
    protected void basicCommit(PDAcroFormField field) {
        JSFieldTools.setJavaScript(field, PDAdditionalActions.CN_trigger_F, this.getFormatScript());
        JSFieldTools.setJavaScript(field, PDAdditionalActions.CN_trigger_K, this.getKeyStrokeScript());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldFormat)) {
            return false;
        }
        FieldFormat format = (FieldFormat)obj;
        if (!this.getType().equals(format.getType())) {
            return false;
        }
        if (this.getFormatScript() == null ? format.getFormatScript() != null : !this.getFormatScript().equals(format.getFormatScript())) {
            return false;
        }
        return !(this.getKeyStrokeScript() == null ? format.getKeyStrokeScript() != null : !this.getKeyStrokeScript().equals(format.getKeyStrokeScript()));
    }

    public String getFormatScript() {
        return this.formatScript;
    }

    public String getKeyStrokeScript() {
        return this.keyStrokeScript;
    }

    @Override
    protected IScriptBasedObject parseObject(PDAcroFormField field) {
        return FieldFormat.createFromField(field);
    }

    public void setFormatScript(String formatScript) {
        this.formatScript = formatScript;
    }

    public void setKeyStrokeScript(String keyStrokeScript) {
        this.keyStrokeScript = keyStrokeScript;
    }
}

