/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.IScriptBasedObject;
import de.intarsys.pdf.design.widget.format.JSFieldTools;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import java.util.List;

public abstract class CommonScriptBasedObject
implements IScriptBasedObject {
    public static final String WARNING_GENERATED_SCRIPT = "/* WARNING: This script was generated and might be deleted automatically! */\n\n";

    protected CommonScriptBasedObject() {
    }

    protected abstract void basicCommit(PDAcroFormField var1);

    @Override
    public void commit(PDAcroFormField field) {
        this.generateScripts();
        if (this.getImplementationName() != null) {
            JSFieldTools.setDocumentJavaScript(field.getDoc(), this.getImplementationName(), WARNING_GENERATED_SCRIPT + this.getImplementationScript());
        }
        this.basicCommit(field);
    }

    protected abstract void generateScripts();

    protected String getImplementationName() {
        return null;
    }

    protected String getImplementationScript() {
        return null;
    }

    protected abstract IScriptBasedObject parseObject(PDAcroFormField var1);

    @Override
    public void release(PDAcroFormField field) {
        if (this.getImplementationName() != null) {
            List leafFields;
            boolean deleteDocumentJS = true;
            PDAcroForm form = field.getAcroForm();
            if (form != null && (leafFields = form.getAcroForm().collectLeafFields()) != null) {
                for (PDAcroFormField leafField : leafFields) {
                    IScriptBasedObject object;
                    if (leafField.cosGetObject().equals(field.cosGetObject()) || !((object = this.parseObject(leafField)) instanceof CommonScriptBasedObject) || !this.getImplementationName().equals(((CommonScriptBasedObject)object).getImplementationName())) continue;
                    deleteDocumentJS = false;
                    break;
                }
            }
            if (deleteDocumentJS) {
                JSFieldTools.setDocumentJavaScript(field.getDoc(), this.getImplementationName(), null);
            }
        }
    }
}

