/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation.markup;

import de.intarsys.pdf.app.annotation.markup.MarkupFactory;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDInkAnnotation;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDPage;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.util.Map;

public class MarkupInkFactory
extends MarkupFactory {
    @Override
    protected PDAnnotation basicCreateAnnotation(PDPage page, CDSRectangle rect, Map attributes) {
        PDMarkupAnnotation newAnnot = (PDMarkupAnnotation)PDInkAnnotation.META.createNew();
        return newAnnot;
    }

    @Override
    protected void createAnnotationStateFromShape(PDAnnotation annotation, Shape shape) {
        COSArray inkList = COSArray.create();
        if (shape != null) {
            COSArray inkSegment = null;
            PathIterator itVertices = shape.getPathIterator(null);
            float[] coords = new float[6];
            while (!itVertices.isDone()) {
                int type = itVertices.currentSegment(coords);
                if (type == 0 || inkSegment == null) {
                    if (inkSegment != null) {
                        inkList.add((COSObject)inkSegment);
                    }
                    inkSegment = COSArray.create();
                }
                inkSegment.add((COSObject)COSFixed.create((float)coords[0]));
                inkSegment.add((COSObject)COSFixed.create((float)coords[1]));
                itVertices.next();
            }
            if (inkSegment != null) {
                inkList.add(inkSegment);
            }
        }
        annotation.cosSetField(PDMarkupAnnotation.DK_InkList, (COSObject)inkList);
    }

    public COSName getAnnotationType() {
        return PDMarkupAnnotation.CN_Subtype_Ink;
    }
}

