/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation.markup;

import de.intarsys.pdf.app.annotation.common.CommonAnnotationFactory;
import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.awt.Shape;
import java.util.Map;

public abstract class MarkupFactory
extends CommonAnnotationFactory {
    public static final String ATTR_CREATED = "created";
    public static final String ATTR_SUBJECT = "subject";
    public static final String ATTR_CONTENTS = "contents";
    public static final String ATTR_TITLE = "title";
    protected static final float[] DEFAULT_BORDERCOLOR = new float[]{0.0f, 0.0f, 0.0f};
    protected static final float DEFAULT_BORDERWIDTH = 1.0f;
    protected static final String PROP_USER_NAME = System.getProperty("user.name");

    @Override
    protected void createAnnotationState(PDPage page, PDAnnotation annotation, CDSRectangle rect, Map attributes) throws ObjectCreationException {
        String subject;
        Shape shape = (Shape)attributes.get("shape");
        PDMarkupAnnotation markup = (PDMarkupAnnotation)annotation;
        markup.setColor(DEFAULT_BORDERCOLOR);
        markup.setBorderStyleWidth(1.0f);
        Object created = attributes.get(ATTR_CREATED);
        if (created == null) {
            created = DateEnvironment.get().now();
        }
        COSObject cdsCreated = CDSDate.createFrom(created).cosGetObject();
        markup.cosSetField(PDMarkupAnnotation.DK_CreationDate, cdsCreated);
        markup.setPrint(true);
        String title = StringTools.nullOrString(attributes.get(ATTR_TITLE));
        if (title == null) {
            title = this.getUserName();
        }
        markup.setText(title);
        String contents = StringTools.nullOrString(attributes.get(ATTR_CONTENTS));
        if (contents != null) {
            markup.setContents(contents);
        }
        if ((subject = StringTools.nullOrString(attributes.get(ATTR_SUBJECT))) != null) {
            markup.setSubject(subject);
        }
        super.createAnnotationState(page, (PDAnnotation)markup, rect, attributes);
        this.createAnnotationStateFromShape(annotation, shape);
    }

    protected abstract void createAnnotationStateFromShape(PDAnnotation var1, Shape var2);

    protected String getUserName() {
        return PROP_USER_NAME;
    }
}

