/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.zones;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.zones.IZone;
import de.intarsys.tools.zones.Zone;
import de.intarsys.tools.zones.ZoneSpec;
import java.util.function.Consumer;

public class StandardZone
implements IZone {
    private final IAttributeSupport scope;
    private final IZone parent;
    private final String name;
    private final Consumer<IZone> onEnter;
    private final Consumer<IZone> onLeave;

    public StandardZone(IZone parent, ZoneSpec spec) {
        this((String)(spec.getName() == null ? parent.getName() + "'" : spec.getName()), parent, spec.getAttributeSupport() == null ? new AttributeMap() : spec.getAttributeSupport(), spec.getOnEnter(), spec.getOnLeave());
    }

    protected StandardZone(String name, IZone parent) {
        this(name, parent, new AttributeMap());
    }

    protected StandardZone(String name, IZone parent, IAttributeSupport scope) {
        this.name = name;
        this.parent = parent;
        this.scope = scope;
        this.onEnter = null;
        this.onLeave = null;
    }

    protected StandardZone(String name, IZone parent, IAttributeSupport scope, Consumer<IZone> onBefore, Consumer<IZone> onAfter) {
        this.name = name;
        this.parent = parent;
        this.scope = scope;
        this.onEnter = onBefore;
        this.onLeave = onAfter;
    }

    @Override
    public void enter() {
        int active = Zone.push(this);
        if (active == 1 && this.onEnter != null) {
            this.onEnter.accept(this);
        }
    }

    @Override
    public IZone fork(ZoneSpec spec) {
        return new StandardZone(this, spec);
    }

    @Override
    public Object getAttribute(Object key) {
        Object result = this.scope.getAttribute(key);
        if (result != null) {
            return result;
        }
        if (this.getParent() != null) {
            return this.getParent().getAttribute(key);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IZone getParent() {
        return this.parent;
    }

    @Override
    public void leave() {
        if (Zone.peek() != this) {
            throw new InvalidRequestException("zone " + this.getName() + " not active");
        }
        int count = Zone.count(this);
        try {
            if (count == 1 && this.onLeave != null) {
                this.onLeave.accept(this);
            }
        }
        finally {
            Zone.pop();
        }
    }

    protected void onBefore() {
        this.enter();
    }

    protected void onFinally() {
        this.leave();
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.scope.removeAttribute(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.scope.setAttribute(key, value);
    }

    public String toString() {
        return "zone '" + this.getName() + "'";
    }
}

