/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.xml;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class XMLEncodeSpecialChars
extends FilterReader {
    private StringReader buffer;

    public XMLEncodeSpecialChars(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int c;
        if (this.buffer != null) {
            c = this.buffer.read();
            if (c == -1) {
                this.buffer = null;
            } else {
                return c;
            }
        }
        if ((c = super.read()) == -1) {
            return -1;
        }
        if (c == 34) {
            this.buffer = new StringReader("&quot;");
        } else if (c == 38) {
            this.buffer = new StringReader("&amp;");
        } else if (c == 60) {
            this.buffer = new StringReader("&lt;");
        } else if (c == 62) {
            this.buffer = new StringReader("&gt;");
        } else {
            if (Character.isWhitespace(c)) {
                return c;
            }
            if (c < 32) {
                this.buffer = new StringReader("&#" + c + ";");
            } else {
                return c;
            }
        }
        return this.buffer.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = -1;
        int i = off;
        while (i < off + len) {
            int c = this.read();
            if (c == -1) {
                return result;
            }
            cbuf[i++] = (char)c;
            result = i - off;
        }
        return len;
    }
}

