/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.valueholder;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.valueholder.IValueHolder;

public class ObjectHolder<T>
implements IValueHolder<T> {
    private T value;
    private final Object owner;
    private final Object attribute;
    private final INotificationListener listener;

    public ObjectHolder() {
        this.owner = null;
        this.attribute = null;
        this.listener = null;
        this.value = null;
    }

    public ObjectHolder(Object owner, Object attribute, INotificationListener listener, T value) {
        this.owner = owner;
        this.attribute = attribute;
        this.listener = listener;
        this.value = value;
    }

    public ObjectHolder(T value) {
        this.owner = null;
        this.attribute = null;
        this.listener = null;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        ObjectHolder objectHolder = this;
        synchronized (objectHolder) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(T newValue) {
        T oldValue;
        ObjectHolder objectHolder = this;
        synchronized (objectHolder) {
            oldValue = this.value;
            if (newValue == oldValue) {
                return oldValue;
            }
            this.value = newValue;
        }
        this.triggerChanged(this.attribute, oldValue, newValue);
        return oldValue;
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        if (this.listener != null) {
            this.listener.handleEvent(new AttributeChangedEvent(this.owner, attribute, oldValue, newValue));
        }
    }
}

