/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.validation;

import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.notice.INoticesSupport;
import de.intarsys.tools.notice.Notice;
import de.intarsys.tools.validation.IValidationResult;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ValidationResult
implements IValidationResult {
    private final Object target;
    private final long timestamp;
    private boolean hasInfo;
    private boolean hasError;
    private boolean hasWarning;
    private final List<INotice> notices = new CopyOnWriteArrayList<INotice>();

    public ValidationResult(Object target) {
        this.target = target;
        this.timestamp = System.currentTimeMillis();
    }

    public void addError(String code, String text) {
        Notice note = new Notice(30, true, code, text, this.getTarget());
        this.addNotice(note);
    }

    public void addInfo(String code, String text) {
        Notice note = new Notice(10, true, code, text, this.getTarget());
        this.addNotice(note);
    }

    @Override
    public void addNotice(INotice notification) {
        this.notices.add(notification);
        this.hasInfo |= notification.getSeverity() == 10;
        this.hasWarning |= notification.getSeverity() == 20;
        this.hasError |= notification.getSeverity() == 30;
    }

    public void addNotice(int severity, boolean sticky, IMessage message) {
        Notice note = new Notice(severity, sticky, message);
        this.addNotice(note);
    }

    public void addNotice(int severity, String code, String text, boolean sticky) {
        Notice note = new Notice(severity, sticky, code, text, this.getTarget());
        this.addNotice(note);
    }

    public void addNotices(INoticesSupport ns) {
        if (ns == null) {
            return;
        }
        for (INotice notice : ns.getNotices()) {
            this.addNotice(notice);
        }
    }

    public void addWarning(IMessage message) {
        Notice note = new Notice(20, true, message);
        this.addNotice(note);
    }

    public void addWarning(String code, String text) {
        Notice note = new Notice(20, true, code, text, this.getTarget());
        this.addNotice(note);
    }

    @Override
    public void clearNotices() {
        this.notices.clear();
    }

    @Override
    public List<INotice> getNotices() {
        return this.notices;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public boolean hasInfo() {
        return this.hasInfo;
    }

    @Override
    public boolean hasWarning() {
        return this.hasWarning;
    }

    @Override
    public boolean removeNotice(INotice notice) {
        return this.notices.remove(notice);
    }
}

