/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.url;

import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.string.StringTools;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class URLTools {
    public static Map<String, List<String>> getQueryParameters(String queryString) {
        if (StringTools.isEmpty(queryString)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(queryString.split("&")).map(URLTools::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public static Map<String, List<String>> getQueryParameters(URL url) {
        return URLTools.getQueryParameters(url.getQuery());
    }

    public static AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String param) {
        int idx = param.indexOf("=");
        String key = idx > 0 ? param.substring(0, idx) : param;
        String value = idx > 0 && param.length() > idx + 1 ? param.substring(idx + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, Object>(URLDecoder.decode(key, StandardCharsets.UTF_8), (value == null ? null : URLDecoder.decode(value, StandardCharsets.UTF_8)));
    }

    public static String withLeadingSeparator(String path) {
        return PathTools.withLeadingSeparator(path);
    }

    public static String withoutLeadingSeparator(String path) {
        return PathTools.withoutLeadingSeparator(path);
    }

    public static String withoutTrailingSeparator(String path) {
        return PathTools.withoutTrailingSeparator(path);
    }

    public static String withTrailingSeparator(String path) {
        return PathTools.withTrailingSeparator(path);
    }

    private URLTools() {
    }
}

