/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.url;

import de.intarsys.tools.exception.InternalError;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class URLEncodingTools {
    public static final String CHARSET_DEFAULT = "UTF-8";

    public static String decode(String value, String encoding) throws UnsupportedEncodingException {
        return URLDecoder.decode(value, encoding != null ? encoding : CHARSET_DEFAULT);
    }

    public static String decodeCharset(String value, Charset encoding) {
        try {
            return URLDecoder.decode(value, encoding.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("required encoding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> decodeEntity(String content, String encoding) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringTools.isEmpty(content)) {
            return parameters;
        }
        try (Scanner scanner = new Scanner(content);){
            scanner.useDelimiter("&");
            while (scanner.hasNext()) {
                String parameter = scanner.next();
                int pos = parameter.indexOf(61);
                if (pos == -1) {
                    throw new IllegalArgumentException("bad parameter");
                }
                String name = URLEncodingTools.decode(parameter.substring(0, pos), encoding);
                String value = "";
                if (parameter.length() > pos) {
                    value = URLEncodingTools.decode(parameter.substring(pos + 1), encoding);
                }
                parameters.put(name, value);
            }
            HashMap<String, String> hashMap = parameters;
            return hashMap;
        }
    }

    public static String encode(String value, String encoding) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, encoding != null ? encoding : CHARSET_DEFAULT);
    }

    public static String encodeCharset(String value, Charset encoding) {
        try {
            return URLEncoder.encode(value, encoding != null ? encoding.name() : CHARSET_DEFAULT);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("required encoding");
        }
    }

    public static String encodeEntity(Map<String, String> parameters, String encoding) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            String encodedValue;
            String encodedName = URLEncodingTools.encode(parameter.getKey(), encoding);
            String value = parameter.getValue();
            String string = encodedValue = value != null ? URLEncodingTools.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }

    private URLEncodingTools() {
    }
}

