/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IActivityClient;
import de.intarsys.tools.activity.IActivityHandler;
import de.intarsys.tools.activity.IActivityView;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.concurrent.IExecutionDecorator;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.ui.IUIComponent;
import de.intarsys.tools.ui.toolkit.Toolkit;
import de.intarsys.tools.valueholder.IValueHolder;
import java.util.ArrayDeque;
import java.util.Deque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UIComponent<M, C, T>
implements IUIComponent<M, C, T>,
IElementConfigurable {
    private static final String LOG_TEMPLATE = "UI {}";
    private static final Logger Log = LoggerFactory.getLogger(UIComponent.class);
    private UIComponentActivityHandler activityHandler;
    private C container;
    private final IUIComponent parent;
    private T component;
    private final IValueHolder<M> valueHolder;
    private final INotificationListener<AttributeChangedEvent> listenModelChange = new INotificationListener<AttributeChangedEvent>(){

        @Override
        public void handleEvent(AttributeChangedEvent event) {
            UIComponent.this.modelChanged(event);
        }
    };
    private IElement configuration;
    private boolean componentCreated;
    private boolean disposed;
    private boolean suspended;
    private final Object runtimeStateLock = new Object();
    private final Deque<IActivity<?>> activityStack = new ArrayDeque();

    protected UIComponent(IUIComponent<?, C, T> parent) {
        this.parent = parent;
        this.valueHolder = new LocalValueHolder(null);
    }

    protected void armModel(Object value) {
        if (value instanceof INotificationSupport) {
            ((INotificationSupport)value).addNotificationListener(AttributeChangedEvent.ID, this.listenModelChange);
        }
        if (this.activityHandler != null) {
            this.activityHandler.armModel(value);
        }
    }

    protected void basicAssociateComponent() {
    }

    protected abstract T basicCreateComponent(C var1);

    protected void basicDispose() {
    }

    protected void basicResume() {
    }

    protected void basicSetValue(M value) {
        if (this.getComponent() != null) {
            this.callUpdateView(null);
        }
    }

    protected void basicSuspend() {
    }

    private void callUpdateView(final Event event) {
        if (!this.isUiActive()) {
            return;
        }
        Toolkit.get().invokeInUI(this.decorate(new Runnable(){

            @Override
            public void run() {
                if (!UIComponent.this.isUiActive()) {
                    return;
                }
                Log.trace(UIComponent.LOG_TEMPLATE, (Object)this);
                try {
                    UIComponent.this.updateView(event);
                }
                catch (Exception e) {
                    Log.warn("UI {} unexpected error", (Object)this, (Object)e);
                }
            }

            public String toString() {
                return "updateView";
            }
        }));
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.configuration = element;
    }

    @Override
    public final void createComponent(C parent) {
        this.setContainer(parent);
        T tempComponent = this.basicCreateComponent(parent);
        this.setComponent(tempComponent);
        this.componentCreated = true;
        this.basicAssociateComponent();
        this.callUpdateView(null);
    }

    protected Runnable decorate(Runnable cmd) {
        if (this.getValue() instanceof IExecutionDecorator) {
            return () -> ((IExecutionDecorator)this.getValue()).execute(cmd);
        }
        return cmd;
    }

    protected void disarmModel(Object oldValue) {
        if (oldValue instanceof INotificationSupport) {
            ((INotificationSupport)oldValue).removeNotificationListener(AttributeChangedEvent.ID, this.listenModelChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        Log.trace("dispose called");
        Object object = this.runtimeStateLock;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
        }
        this.disarmModel(this.getValue());
        this.componentCreated = false;
        this.basicDispose();
        Log.trace("UI queuing dispose");
        try {
            Toolkit.get().invokeNow(this.decorate(() -> {
                this.uiDispose();
                Log.trace("UI dispose called");
            }));
        }
        catch (Exception e) {
            Log.warn("dispose UI failed", (Throwable)e);
        }
    }

    protected void execute(Runnable cmd) {
        if (this.getValue() instanceof IExecutionDecorator) {
            ((IExecutionDecorator)this.getValue()).execute(cmd);
        } else {
            cmd.run();
        }
    }

    @Override
    public final T getComponent() {
        return this.component;
    }

    public IElement getConfiguration() {
        return this.configuration;
    }

    protected C getContainer() {
        return this.container;
    }

    protected IActivity<?> getCurrentActivity() {
        return this.activityStack.peek();
    }

    public IUIComponent getParent() {
        return this.parent;
    }

    @Override
    public synchronized M getValue() {
        return this.getValueHolder().get();
    }

    protected IValueHolder<M> getValueHolder() {
        return this.valueHolder;
    }

    protected boolean isActivityActive(Class<?> clazz) {
        for (IActivity<?> activity : this.activityStack) {
            if (!clazz.isInstance(activity)) continue;
            return true;
        }
        return false;
    }

    protected boolean isComponentCreated() {
        return this.componentCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Object object = this.runtimeStateLock;
        synchronized (object) {
            return this.disposed;
        }
    }

    protected boolean isInheritValue() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuspended() {
        Object object = this.runtimeStateLock;
        synchronized (object) {
            return this.suspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUiActive() {
        Object object = this.runtimeStateLock;
        synchronized (object) {
            return !this.suspended && !this.disposed;
        }
    }

    protected void modelChanged(AttributeChangedEvent event) {
        if (!this.isComponentCreated()) {
            return;
        }
        Log.trace("UI modelChanged calling updateView");
        this.callUpdateView(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resume() {
        Log.trace("resume called");
        Object object = this.runtimeStateLock;
        synchronized (object) {
            if (!this.suspended) {
                return;
            }
            this.suspended = false;
        }
        this.basicResume();
        Log.trace("UI queuing resume");
        try {
            Toolkit.get().invokeNow(this.decorate(() -> {
                this.uiResume();
                Log.trace("UI resume called");
            }));
        }
        catch (Exception e) {
            Log.warn("resume UI failed", (Throwable)e);
        }
    }

    protected void setActivityHandler(UIComponentActivityHandler activityHandler) {
        this.activityHandler = activityHandler;
    }

    protected void setComponent(T component) {
        this.component = component;
    }

    protected void setComponentCreated(boolean componentAvailable) {
        this.componentCreated = componentAvailable;
    }

    protected void setContainer(C parent) {
        this.container = parent;
    }

    @Override
    public synchronized M setValue(M value) {
        return this.getValueHolder().set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void suspend() {
        Log.trace("suspend called");
        Object object = this.runtimeStateLock;
        synchronized (object) {
            if (this.suspended) {
                return;
            }
            this.suspended = true;
        }
        this.basicSuspend();
        Log.trace("UI queuing suspend");
        try {
            Toolkit.get().invokeNow(this.decorate(() -> {
                this.uiSuspend();
                Log.trace("UI suspend called");
            }));
        }
        catch (Exception e) {
            Log.warn("suspend UI failed", (Throwable)e);
        }
    }

    protected void uiDispose() {
    }

    protected void uiResume() {
    }

    protected void uiSuspend() {
    }

    protected void updateView(Event e) {
    }

    private class LocalValueHolder
    implements IValueHolder<M> {
        private M value;

        LocalValueHolder(M value) {
            this.set((M)value);
        }

        @Override
        public M get() {
            return this.value;
        }

        @Override
        public M set(M newValue) {
            Object oldValue = this.value;
            if (oldValue == newValue) {
                return this.value;
            }
            UIComponent.this.disarmModel(oldValue);
            UIComponent.this.armModel(newValue);
            this.value = newValue;
            UIComponent.this.basicSetValue(this.value);
            return oldValue;
        }
    }

    protected abstract class UIComponentActivityHandler
    implements IActivityHandler {
        protected UIComponentActivityHandler() {
        }

        protected final void activityChanged(final IActivity<?> activity, final AttributeChangedEvent event) {
            if (!UIComponent.this.isUiActive()) {
                return;
            }
            this.syncActivityChanged(activity, event);
            Toolkit.get().invokeInUI(UIComponent.this.decorate(new Runnable(){

                @Override
                public void run() {
                    if (!UIComponent.this.isUiActive()) {
                        return;
                    }
                    Log.trace(UIComponent.LOG_TEMPLATE, (Object)this);
                    UIComponentActivityHandler.this.uiActivityChanged(activity, event);
                }

                public String toString() {
                    return "activityChanged " + activity;
                }
            }));
        }

        @Override
        public final <R> IActivityView activityEnter(final IActivity<R> activity) {
            if (!UIComponent.this.isUiActive()) {
                return null;
            }
            if (activity instanceof INotificationSupport) {
                ((INotificationSupport)((Object)activity)).addNotificationListener(AttributeChangedEvent.ID, new INotificationListener<AttributeChangedEvent>(){

                    @Override
                    public void handleEvent(AttributeChangedEvent event) {
                        UIComponentActivityHandler.this.activityChanged(activity, event);
                    }
                });
            }
            activity.addTaskCallback(new ITaskCallback<R>(){

                @Override
                public void failed(TaskFailed exception) {
                    try {
                        UIComponentActivityHandler.this.activityFailed(activity);
                    }
                    finally {
                        UIComponentActivityHandler.this.activityFinally(activity);
                    }
                }

                @Override
                public void finished(R result) {
                    try {
                        UIComponentActivityHandler.this.activityFinished(activity);
                    }
                    finally {
                        UIComponentActivityHandler.this.activityFinally(activity);
                    }
                }
            });
            this.syncActivityEnter(activity);
            Toolkit.get().invokeInUI(UIComponent.this.decorate(new Runnable(){

                @Override
                public void run() {
                    if (!UIComponent.this.isUiActive()) {
                        return;
                    }
                    Log.trace(UIComponent.LOG_TEMPLATE, (Object)this);
                    UIComponentActivityHandler.this.uiActivityEnter(activity);
                    UIComponent.this.activityStack.push(activity);
                }

                public String toString() {
                    return "activityEnter " + activity;
                }
            }));
            return null;
        }

        protected final void activityFailed(final IActivity<?> activity) {
            if (!UIComponent.this.isUiActive()) {
                return;
            }
            this.syncActivityFailed(activity);
            Toolkit.get().invokeInUI(UIComponent.this.decorate(new Runnable(){

                @Override
                public void run() {
                    if (!UIComponent.this.isUiActive()) {
                        return;
                    }
                    Log.trace(UIComponent.LOG_TEMPLATE, (Object)this);
                    UIComponentActivityHandler.this.uiActivityFailed(activity);
                }

                public String toString() {
                    return "activityFailed " + activity;
                }
            }));
        }

        protected final void activityFinally(final IActivity<?> activity) {
            if (!UIComponent.this.isUiActive()) {
                return;
            }
            this.syncActivityFinally(activity);
            Toolkit.get().invokeInUI(UIComponent.this.decorate(new Runnable(){

                @Override
                public void run() {
                    UIComponent.this.activityStack.remove(activity);
                    if (!UIComponent.this.isUiActive()) {
                        return;
                    }
                    Log.trace(UIComponent.LOG_TEMPLATE, (Object)this);
                    UIComponentActivityHandler.this.uiActivityFinally(activity);
                }

                public String toString() {
                    return "activityFinally " + activity;
                }
            }));
        }

        protected final void activityFinished(final IActivity<?> activity) {
            if (!UIComponent.this.isUiActive()) {
                return;
            }
            this.syncActivityFinished(activity);
            Toolkit.get().invokeInUI(UIComponent.this.decorate(new Runnable(){

                @Override
                public void run() {
                    if (!UIComponent.this.isUiActive()) {
                        return;
                    }
                    Log.trace(UIComponent.LOG_TEMPLATE, (Object)this);
                    UIComponentActivityHandler.this.uiActivityFinished(activity);
                }

                public String toString() {
                    return "activityFinished " + activity;
                }
            }));
        }

        public void armModel(Object value) {
            if (value instanceof IActivityClient) {
                ((IActivityClient)value).setActivityHandler(this);
            }
        }

        protected void syncActivityChanged(IActivity<?> activity, AttributeChangedEvent event) {
        }

        protected void syncActivityEnter(IActivity<?> activity) {
        }

        protected void syncActivityFailed(IActivity<?> activity) {
        }

        protected void syncActivityFinally(IActivity<?> activity) {
        }

        protected void syncActivityFinished(IActivity<?> activity) {
        }

        protected void uiActivityChanged(IActivity<?> activity, AttributeChangedEvent event) {
        }

        protected void uiActivityEnter(IActivity<?> activity) {
        }

        protected void uiActivityFailed(IActivity<?> activity) {
        }

        protected void uiActivityFinally(IActivity<?> activity) {
        }

        protected void uiActivityFinished(IActivity<?> activity) {
        }
    }
}

