/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tag;

import de.intarsys.tools.string.StringTools;
import java.util.HashMap;
import java.util.Map;

public class Tag {
    private final String key;
    private final String value;
    private Map<String, Object> properties;

    public Tag(String key) {
        this.key = key;
        this.value = "";
    }

    public Tag(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tag) {
            return this.equalsFromTag((Tag)obj);
        }
        return false;
    }

    protected boolean equalsFromTag(Tag obj) {
        return this.isEqual(obj.value, this.value) && this.isEqual(obj.key, this.key);
    }

    public String getKey() {
        return this.key;
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.key.hashCode() + this.value.hashCode();
    }

    protected boolean isEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public String toString() {
        if (StringTools.isEmpty(this.value)) {
            return this.key;
        }
        return this.key + "=" + this.value;
    }
}

