/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class StreamTools {
    public static final int MAX_BUFFER = 100000;

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated(since="4.25.0")
    public static void copy(InputStream source, OutputStream destination) throws IOException {
        try {
            byte[] b = new byte[100000];
            int i = source.read(b);
            while (i != -1) {
                destination.write(b, 0, i);
                i = source.read(b);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("copying failed (" + e.getMessage() + ")", e);
        }
    }

    public static void copy(InputStream source, String sourceEncoding, OutputStream destination, String destinationEncoding) throws IOException {
        if (sourceEncoding == null || destinationEncoding == null || sourceEncoding.equals(destinationEncoding)) {
            StreamTools.copy(source, destination);
            return;
        }
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            reader = new InputStreamReader(source, sourceEncoding);
            writer = new OutputStreamWriter(destination, destinationEncoding);
            char[] c = new char[100000];
            int i = reader.read(c);
            while (i != -1) {
                writer.write(c, 0, i);
                i = reader.read(c);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("copying failed (" + e.getMessage() + ")");
        }
    }

    @Deprecated(since="4.25.0")
    public static void copy(Reader reader, Writer writer) throws IOException {
        try {
            char[] c = new char[100000];
            int i = reader.read(c);
            while (i != -1) {
                writer.write(c, 0, i);
                i = reader.read(c);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("copying failed (" + e.getMessage() + ")");
        }
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        try {
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
        finally {
            StreamTools.close(is);
        }
    }

    public static String getString(InputStream is, Charset charset) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            StreamTools.copy(is, os);
        }
        finally {
            StreamTools.close(is);
            StreamTools.close(os);
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return os.toString(charset.name());
    }

    public static String getString(InputStream is, String encoding) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            StreamTools.copy(is, os);
        }
        finally {
            StreamTools.close(is);
            StreamTools.close(os);
        }
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return os.toString(encoding);
    }

    public static String getString(Reader r) throws IOException {
        try {
            StringWriter w = new StringWriter();
            StreamTools.copy(r, w);
            String string = w.toString();
            return string;
        }
        finally {
            StreamTools.close(r);
        }
    }

    public static int read(InputStream is, byte[] b, int off, int len) throws IOException {
        int total;
        int result;
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (total = 0; total < len && (result = is.read(b, off + total, len - total)) != -1; total += result) {
        }
        return total == 0 ? -1 : total;
    }

    public static int read(IRandomAccess ra, byte[] b, int off, int len) throws IOException {
        int total;
        int result;
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (total = 0; total < len && (result = ra.read(b, off + total, len - total)) != -1; total += result) {
        }
        return total == 0 ? -1 : total;
    }

    public static void reset(BufferedInputStream bufferedStream) {
        try {
            bufferedStream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int suggestBufferSize(InputStream is) {
        try {
            return StreamTools.suggestBufferSize(is.available());
        }
        catch (IOException e) {
            return StreamTools.suggestBufferSize(-1L);
        }
    }

    public static int suggestBufferSize(long totalSize) {
        int bufferSize = totalSize < 32768L ? 4024 : (totalSize < 0x100000L ? 32768 : 98304);
        return bufferSize;
    }

    @Deprecated
    public static byte[] toByteArray(InputStream is) throws IOException {
        return StreamTools.getBytes(is);
    }

    @Deprecated
    public static String toString(InputStream is, Charset charset) throws IOException {
        return StreamTools.getString(is, charset);
    }

    @Deprecated
    public static String toString(InputStream is, String encoding) throws IOException {
        return StreamTools.getString(is, encoding);
    }

    @Deprecated
    public static String toString(Reader r) throws IOException {
        return StreamTools.getString(r);
    }

    private StreamTools() {
    }
}

