/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servicelocator;

import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.servicelocator.IServiceResolver;
import de.intarsys.tools.servicelocator.ServiceCreationException;
import de.intarsys.tools.servicelocator.ServiceImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResolverResolver<T>
implements IServiceResolver<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public T apply(Class<T> lookupClass) {
        ServiceImplementation implementation = lookupClass.getAnnotation(ServiceImplementation.class);
        if (implementation != null) {
            Class<? extends IServiceResolver>[] resolverClasses;
            for (Class<? extends IServiceResolver> resolverClass : resolverClasses = implementation.resolver()) {
                try {
                    IServiceResolver resolver = ObjectTools.createObject(resolverClass, IServiceResolver.class);
                    ObjectTools.initObject(resolver);
                    this.log.trace("ServiceResolver {} resolve {} with {}", new Object[]{this, lookupClass, resolverClass});
                    Object object = resolver.apply(lookupClass);
                    if (object == null) continue;
                    return (T)object;
                }
                catch (ObjectCreationException e) {
                    throw new ServiceCreationException("service creation for " + lookupClass + " failed", e);
                }
            }
        }
        return null;
    }
}

