/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.sax;

import de.intarsys.tools.sax.ISAXElementHandler;
import de.intarsys.tools.sax.SAXContextBasedHandler;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SAXAbstractElementHandler
implements ISAXElementHandler {
    private SAXContextBasedHandler contextHandler;
    private ISAXElementHandler parent;
    private String localName = "";
    private String uri = "";
    private char[] chars;
    private int charCount;
    private String data;
    private int line;
    private int column;
    private int endline;
    private int endcolumn;
    private boolean leaf = true;
    private Map parameters;

    protected SAXAbstractElementHandler() {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        if (!this.isCharacterDataAllowed()) {
            if (this.isWhitespaceAllowed() && new String(ch, start, length).trim().length() == 0) {
                return;
            }
            throw new SAXParseException("unexpected character data in <" + this.getLocalName() + ">", this.getLocator());
        }
        char[] newChars = new char[this.charCount + length];
        if (this.charCount > 0) {
            System.arraycopy(this.chars, 0, newChars, 0, this.charCount);
        }
        System.arraycopy(ch, start, newChars, this.charCount, length);
        this.charCount += length;
        this.chars = newChars;
        this.data = null;
    }

    @Override
    public void endChildElement(ISAXElementHandler elementHandler) throws SAXException {
    }

    @Override
    public void endDocumentElement() throws SAXException {
    }

    @Override
    public void endElement(String pUri, String local, String name) throws SAXException {
    }

    public char[] getChars() {
        return this.chars;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public SAXContextBasedHandler getContextHandler() {
        return this.contextHandler;
    }

    public String getData() {
        if (this.data == null) {
            this.data = this.charCount > 0 ? new String(this.chars) : "";
        }
        return this.data;
    }

    public int getEndColumn() {
        return this.endcolumn;
    }

    public int getEndLine() {
        return this.endline;
    }

    public int getLine() {
        return this.line;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public Locator getLocator() {
        return this.getContextHandler().getLocator();
    }

    public int getNesting() {
        return this.getContextHandler().getNesting();
    }

    public Map getParameters() {
        return this.parameters;
    }

    @Override
    public ISAXElementHandler getParent() {
        return this.parent;
    }

    public String getPath() {
        Object result = this.getLocalName() == null ? "?" : this.getLocalName();
        for (ISAXElementHandler current = this.getParent(); current != null; current = current.getParent()) {
            result = current.getLocalName() + "/" + (String)result;
        }
        return result;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void initialize(String pUri, String local, String name, Attributes attrs) throws SAXException {
        String localOrName = local == null ? name : local;
        this.setLocalName(localOrName);
        this.setURI(pUri);
    }

    @Override
    public void initializeDocumentElement() throws SAXException {
        this.setLocalName("document");
    }

    public boolean isCharacterDataAllowed() {
        return true;
    }

    @Override
    public boolean isDocumentHandler() {
        return this.getContextHandler().getDocumentElement() == this;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    @Override
    public boolean isRootElementHandler() {
        return this.getParent() != null && this.getParent().isDocumentHandler();
    }

    public boolean isWhitespaceAllowed() {
        return true;
    }

    @Override
    public void markEndLocation(int newLine, int newColumn) {
        this.endline = newLine;
        this.endcolumn = newColumn;
    }

    @Override
    public void markStartLocation(int newLine, int newColumn) {
        this.line = newLine;
        this.column = newColumn;
    }

    public void processAttribute(String name, String value) throws SAXException {
        this.parameters.put(name, value);
    }

    @Override
    public void processAttributes(Attributes attrs) throws SAXException {
        if (attrs != null && attrs.getLength() > 0) {
            this.parameters = new HashMap();
            int cntAttrs = attrs.getLength();
            for (int i = 0; i < cntAttrs; ++i) {
                String attrName = attrs.getLocalName(i);
                String attrValue = attrs.getValue(i);
                this.processAttribute(attrName, attrValue);
            }
        }
    }

    public void reset() {
        this.localName = "";
        this.uri = "";
        this.data = null;
        this.chars = null;
        this.charCount = 0;
        this.line = 0;
        this.column = 0;
        this.leaf = true;
    }

    public void setChars(char[] newChars) {
        this.chars = newChars;
    }

    public void setColumn(int newColumn) {
        this.column = newColumn;
    }

    @Override
    public void setContextHandler(SAXContextBasedHandler newContextHandler) {
        this.contextHandler = newContextHandler;
    }

    public void setLine(int newLine) {
        this.line = newLine;
    }

    @Override
    public void setLocalName(String newLocalName) {
        this.localName = newLocalName;
    }

    @Override
    public void setParent(ISAXElementHandler newParent) {
        this.parent = newParent;
    }

    @Override
    public void setURI(String newUri) {
        this.uri = newUri;
    }

    @Override
    public void startChildElement(ISAXElementHandler element) throws SAXException {
        this.leaf = false;
    }

    @Override
    public void started() throws SAXException {
    }

    @Override
    public ISAXElementHandler startElement(String pUri, String local, String name, Attributes attrs) throws SAXException {
        if (this.getParent() == null) {
            throw new SAXParseException("tag <" + local + "> is not a supported root tag", this.getLocator());
        }
        throw new SAXParseException("tag <" + local + "> in <" + this.getLocalName() + "> not supported", this.getLocator());
    }
}

