/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.ReportStatus;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.IReporter;
import de.intarsys.tools.reporter.IReporterSupport;
import de.intarsys.tools.reporter.ReportDispatcher;

public class ReplayReporter
implements IReporter,
IReporterSupport {
    private final Object owner;
    private final ReportDispatcher dispatcher;
    private final ReportEvent[] messages = new ReportEvent[10];
    private int first = 0;

    public ReplayReporter(Object owner) {
        this.owner = owner;
        this.dispatcher = new ReportDispatcher(owner);
    }

    protected void addMessage(ReportEvent message) {
        this.messages[this.first] = message;
        this.first = (this.first + 1) % this.messages.length;
    }

    @Override
    public void addReporter(IReporter reporter) {
        this.dispatcher.addReporter(reporter);
        this.replay(reporter);
    }

    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void removeReporter(IReporter reporter) {
        this.dispatcher.removeReporter(reporter);
    }

    protected void replay(IReporter reporter) {
        for (int i = 0; i < this.messages.length; ++i) {
            int index = (i + this.first) % this.messages.length;
            ReportEvent message = this.messages[index];
            if (message == null) continue;
            if (message.isTypeStatus()) {
                reporter.reportStatus(message.getText(), message.getStyle());
                continue;
            }
            if (message.isTypeMessage()) {
                reporter.reportMessage(message.getTitle(), message.getText(), message.getStyle());
                continue;
            }
            if (!message.isTypeError()) continue;
            reporter.reportError(message.getTitle(), message.getText(), message.getThrowable(), message.getStyle());
        }
    }

    @Override
    public IProgressMonitor reportActivityStart(IMessage message, int style) {
        final IProgressMonitor nestedMonitor = this.dispatcher.reportActivityStart(message, style);
        ReportStatus activity = new ReportStatus<IActivity<?>>(null){

            @Override
            public void begin(String name, float totalWork) {
                nestedMonitor.begin(name, totalWork);
                ReplayReporter.this.addMessage(new ReportEvent(name, totalWork));
                super.begin(name, totalWork);
            }

            @Override
            protected void onFinally() {
                nestedMonitor.end();
                ReplayReporter.this.addMessage(new ReportEvent());
                super.onFinally();
            }

            @Override
            public void subTask(String name) {
                nestedMonitor.subTask(name);
                ReplayReporter.this.addMessage(new ReportEvent(name));
                super.subTask(name);
            }

            @Override
            public void worked(float amount) {
                nestedMonitor.worked(amount);
                ReplayReporter.this.addMessage(new ReportEvent(amount));
                super.worked(amount);
            }
        };
        activity.setMessage(message);
        activity.enter();
        this.addMessage(new ReportEvent(message, style));
        return activity;
    }

    @Override
    public void reportError(String title, String text, Throwable t, int style) {
        this.addMessage(new ReportEvent(5, title, text, t, style));
        this.dispatcher.reportError(title, text, t, style);
    }

    @Override
    public void reportMessage(String title, String text, int style) {
        this.addMessage(new ReportEvent(4, title, text, null, style));
        this.dispatcher.reportMessage(title, text, style);
    }

    @Override
    public void reportStatus(String text, int style) {
        this.addMessage(new ReportEvent(3, null, text, null, style));
        this.dispatcher.reportStatus(text, style);
    }

    class ReportEvent {
        public static final int TYPE_ACTIVITY_END = 2;
        public static final int TYPE_ACTIVITY_START = 1;
        public static final int TYPE_ACTIVITY_PROGRESS_BEGIN = 6;
        public static final int TYPE_ACTIVITY_PROGRESS_SUBTASK = 7;
        public static final int TYPE_ACTIVITY_PROGRESS_WORKED = 8;
        public static final int TYPE_ERROR = 5;
        public static final int TYPE_MESSAGE = 4;
        public static final int TYPE_STATUS = 3;
        private final int style;
        private final Throwable throwable;
        private final String title;
        private final int type;
        private final Thread thread;
        private final IMessage message;
        private final String text;
        private final float amount;

        public ReportEvent() {
            this.type = 2;
            this.message = null;
            this.thread = Thread.currentThread();
            this.title = null;
            this.text = null;
            this.amount = 0.0f;
            this.throwable = null;
            this.style = 0;
        }

        public ReportEvent(float amount) {
            this.type = 8;
            this.message = null;
            this.thread = Thread.currentThread();
            this.title = null;
            this.throwable = null;
            this.text = null;
            this.amount = amount;
            this.style = 0;
        }

        public ReportEvent(IMessage message, int style) {
            this.type = 1;
            this.message = message;
            this.thread = Thread.currentThread();
            this.title = null;
            this.text = null;
            this.amount = 0.0f;
            this.throwable = null;
            this.style = style;
        }

        public ReportEvent(int type, String title, String text, Throwable t, int style) {
            this.type = type;
            this.message = LiteralMessage.create(text);
            this.thread = Thread.currentThread();
            this.title = title;
            this.text = text;
            this.amount = 0.0f;
            this.throwable = t;
            this.style = style;
        }

        public ReportEvent(String name) {
            this.type = 7;
            this.message = null;
            this.thread = Thread.currentThread();
            this.title = null;
            this.throwable = null;
            this.text = name;
            this.amount = 0.0f;
            this.style = 0;
        }

        public ReportEvent(String name, float total) {
            this.type = 6;
            this.message = null;
            this.thread = Thread.currentThread();
            this.title = null;
            this.throwable = null;
            this.text = name;
            this.amount = total;
            this.style = 0;
        }

        public float getAmount() {
            return this.amount;
        }

        public IMessage getMessage() {
            return this.message;
        }

        public int getStyle() {
            return this.style;
        }

        protected String getText() {
            return this.text;
        }

        public Thread getThread() {
            return this.thread;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String getTitle() {
            return this.title;
        }

        public int getType() {
            return this.type;
        }

        public boolean isTypeActivity() {
            return this.type == 1;
        }

        public boolean isTypeError() {
            return this.type == 5;
        }

        public boolean isTypeMessage() {
            return this.type == 4;
        }

        public boolean isTypeStatus() {
            return this.type == 3;
        }
    }
}

