/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.range;

import de.intarsys.tools.number.NumberList;
import de.intarsys.tools.number.NumberParser;
import de.intarsys.tools.number.NumberWrapper;
import de.intarsys.tools.range.IRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefinedRange
implements IRange {
    private NumberWrapper value;

    public static DefinedRange create(int index) {
        NumberList wrapper = new NumberList();
        wrapper.add(index);
        return new DefinedRange(wrapper);
    }

    public static DefinedRange create(List<Integer> indices) {
        NumberList wrapper = new NumberList();
        wrapper.addAll(indices);
        return new DefinedRange(wrapper);
    }

    public static DefinedRange create(String stringValue) throws IOException {
        NumberWrapper wrapper = NumberParser.parseInteger(stringValue.trim());
        return new DefinedRange(wrapper);
    }

    public DefinedRange(NumberWrapper value) {
        this.value = value;
    }

    @Override
    public List<Integer> getIndices(int current, int count) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Number number : this.getValue()) {
            int index = number.intValue();
            if (index < 0 || index >= count && count >= 0) continue;
            indices.add(index);
        }
        return indices;
    }

    public NumberWrapper getValue() {
        return this.value;
    }
}

