/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;

public class BufferedRandomAccess
extends AbstractRandomAccess {
    private static final int HIGH_BYTE = 255;
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    protected final byte[] bytes;
    protected long bytesOffset;
    protected int localLength;
    protected int localOffset;
    protected final IRandomAccess randomAccess;
    protected long totalOffset;
    private boolean closed;
    protected long totalLength;
    protected boolean bufferChanged;

    public BufferedRandomAccess(IRandomAccess randomAccess) throws IOException {
        this(randomAccess, 0x100000);
    }

    public BufferedRandomAccess(IRandomAccess randomAccess, int bufferSize) throws IOException {
        this.randomAccess = randomAccess;
        this.bytes = new byte[bufferSize];
        this.computeTotalLengthBuffered();
    }

    protected boolean bufferCannotRead() {
        return this.localOffset < 0 || this.localOffset >= this.localLength;
    }

    protected boolean bufferCannotWrite() {
        return this.localOffset < 0 || this.localOffset > this.localLength || this.localOffset >= this.bytes.length;
    }

    protected void bufferRead() throws IOException {
        this.bufferWrite();
        this.bufferReset();
        this.randomAccess.seek(this.bytesOffset);
        this.localLength = this.randomAccess.read(this.bytes, 0, this.bytes.length);
    }

    protected void bufferReset() {
        this.bytesOffset = this.computeBytesOffset(this.totalOffset);
        this.localOffset = (int)(this.totalOffset - this.bytesOffset);
        this.localLength = 0;
    }

    protected void bufferWrite() throws IOException {
        if (this.bufferChanged && this.localLength > 0) {
            this.randomAccess.seek(this.bytesOffset);
            this.randomAccess.write(this.bytes, 0, this.localLength);
        }
        this.bufferChanged = false;
    }

    protected void checkOpen() throws IOException {
        if (this.isClosed()) {
            throw new IOException("random access closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.bufferWrite();
        this.randomAccess.close();
        this.closed = true;
    }

    protected long computeBytesOffset(long pOffset) {
        return pOffset;
    }

    protected void computeTotalLengthBuffered() throws IOException {
        this.totalLength = this.randomAccess.getLength();
    }

    protected void computeTotalLengthWrapped() throws IOException {
        this.randomAccess.setLength(this.totalLength);
    }

    @Override
    public void flush() throws IOException {
        this.checkOpen();
        this.bufferWrite();
        this.randomAccess.flush();
    }

    protected byte[] getBytes() {
        return this.bytes;
    }

    protected long getBytesOffset() {
        return this.bytesOffset;
    }

    @Override
    public long getLength() throws IOException {
        this.checkOpen();
        return this.totalLength;
    }

    protected int getLocalLength() {
        return this.localLength;
    }

    protected int getLocalOffset() {
        return this.localOffset;
    }

    @Override
    public long getOffset() throws IOException {
        this.checkOpen();
        return this.totalOffset;
    }

    public IRandomAccess getRandomAccess() {
        return this.randomAccess;
    }

    protected long getTotalOffset() {
        return this.totalOffset;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return this.randomAccess.isReadOnly();
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        if (this.bufferCannotRead()) {
            if (this.totalOffset >= this.totalLength) {
                return -1;
            }
            this.bufferRead();
            if (this.bufferCannotRead()) {
                return -1;
            }
        }
        ++this.totalOffset;
        return this.bytes[this.localOffset++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int start, int numBytes) throws IOException {
        this.checkOpen();
        if (numBytes == 0) {
            return 0;
        }
        int bytesRead = 0;
        int bytesToRead = numBytes;
        while (bytesRead < numBytes) {
            if (this.bufferCannotRead()) {
                if (this.totalOffset >= this.totalLength) break;
                this.bufferRead();
                if (this.bufferCannotRead()) break;
            }
            int tempCount = Math.min(this.localLength - this.localOffset, bytesToRead);
            System.arraycopy(this.bytes, this.localOffset, buffer, start + bytesRead, tempCount);
            this.localOffset += tempCount;
            this.totalOffset += (long)tempCount;
            bytesRead += tempCount;
            bytesToRead -= tempCount;
        }
        return bytesRead == 0 ? -1 : bytesRead;
    }

    @Override
    public void seek(long offset) throws IOException {
        this.checkOpen();
        if (offset < 0L) {
            throw new IOException("negative offset");
        }
        this.totalOffset = offset;
        this.localOffset = (int)(this.totalOffset - this.bytesOffset);
    }

    @Override
    public void seekBy(long delta) throws IOException {
        this.seek(this.totalOffset + delta);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.checkOpen();
        if (newLength < this.totalOffset) {
            this.totalOffset = newLength;
            if (newLength < this.bytesOffset) {
                this.bytesOffset = this.computeBytesOffset(this.totalOffset);
                this.localLength = 0;
            } else {
                this.localLength = (int)Math.min((long)this.localLength, newLength - this.bytesOffset);
            }
            this.localOffset = (int)(this.totalOffset - this.bytesOffset);
        }
        this.totalLength = newLength;
        this.computeTotalLengthWrapped();
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int start, int numBytes) throws IOException {
        this.checkOpen();
        int bytesWritten = 0;
        int bytesToWrite = numBytes;
        while (bytesWritten < numBytes) {
            if (this.bufferCannotWrite()) {
                this.bufferWrite();
                this.bufferReset();
            }
            int tempCount = Math.min(bytesToWrite, this.bytes.length - this.localOffset);
            System.arraycopy(buffer, start + bytesWritten, this.bytes, this.localOffset, tempCount);
            this.writeMarkChanged(tempCount);
            bytesWritten += tempCount;
            bytesToWrite -= tempCount;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkOpen();
        if (this.bufferCannotWrite()) {
            this.bufferWrite();
            this.bufferReset();
        }
        this.bytes[this.localOffset] = (byte)b;
        this.writeMarkChanged(1);
    }

    protected void writeMarkChanged(int i) {
        this.bufferChanged = true;
        this.totalOffset += (long)i;
        this.localOffset += i;
        if (this.totalOffset > this.totalLength) {
            this.totalLength = this.totalOffset;
        }
        if (this.localOffset >= this.localLength) {
            this.localLength = this.localOffset;
        }
    }
}

